/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.shedule;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.util.Environment;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class EventInfoManager {
	private String _GroupID;
	private Map _Datas;
	private Map _GroupDatas;
	private String _DateStr;
	public EventInfoManager(String groupID,String date) throws PortalException{
		_DateStr=date;
		_GroupID=groupID;
		if(_GroupID==null||_GroupID.length()==0){
			_GroupID="guest";
		}
		try {
			load();
		} catch (IOException e) {
			throw new PortalException(e);
		} catch (ClassNotFoundException e) {
			throw new PortalException(e);
		}

	}
	public Iterator getTask(){
		Collection col=new ArrayList();
		for (Iterator iter = _Datas.keySet().iterator(); iter.hasNext();) {
			String eventId = (String) iter.next();
			if(!eventId.equals("nextId")){
				col.add(_Datas.get(eventId));
			}
		}
		return col.iterator();
	}
	public Iterator getTask(String date){
		Collection col=new ArrayList();
		Map map=(Map)_GroupDatas.get(date);
		if(map!=null){
			for (Iterator iter = map.keySet().iterator(); iter.hasNext();) {
				String eventId = (String) iter.next();
				if(!eventId.equals("nextId")){
					col.add(map.get(eventId));
				}
			}
		}
		return col.iterator();
	}
/*	public SortedMap getMonthTask(){
		Collection col=new ArrayList();
		for (Iterator iter = _GroupDatas.keySet().iterator(); iter.hasNext();) {
			String eventId = (String) iter.next();
			if(!eventId.equals("nextId")){
				col.add(_Datas.get(eventId));
			}
		}
		return col.iterator();
	}
*/	public void removeEventInfo(EventInfo eventInfo) throws PortalException{
		_Datas.remove(eventInfo.getEventId());
		try {
			save();
		} catch (IOException e) {
			throw new PortalException(e);
		} catch (ClassNotFoundException e) {
			throw new PortalException(e);
		}
	}
	public EventInfo getEventInfo(String eventId){
		return (EventInfo)_Datas.get(eventId);
	}
	public void setEventInfo(EventInfo eventInfo) throws PortalException{
		String eventId=eventInfo.getEventId();
		if(eventId==null){
			Long nextId=(Long)_Datas.get("nextId");
			if(nextId==null){
				nextId=new Long(0);
			}
			eventInfo.setEventId(nextId.toString());
			_Datas.put("nextId",new Long(nextId.longValue()+1L));
		}
		_Datas.put(eventInfo.getEventId(),eventInfo);
		try {
			save();
		} catch (IOException e) {
			throw new PortalException(e);
		} catch (ClassNotFoundException e) {
			throw new PortalException(e);
		}
	}
	private synchronized void save() throws IOException, ClassNotFoundException{
		File file=Environment.getRealPath("WEB-INF/data/schedule/events");
		file=new File (file,_GroupID);
		
		FileInputStream fis;
		try {
			fis = new FileInputStream(file);
			ObjectInputStream oiStream=new ObjectInputStream(fis);
			_GroupDatas=(Map)oiStream.readObject();
			oiStream.close();
			fis.close();
		} catch (FileNotFoundException e) {
			_GroupDatas=new HashMap();
		}
		_GroupDatas.put(_DateStr,_Datas);

		FileOutputStream fos=new FileOutputStream(file);
		ObjectOutputStream ooStream=new ObjectOutputStream(fos);
		ooStream.writeObject(_GroupDatas);
		ooStream.close();
		fos.close();
	}
	private void load()throws IOException, ClassNotFoundException{
		File file=Environment.getRealPath("WEB-INF/data/schedule/events");
		file=new File (file,_GroupID);
		FileInputStream fis;
		try {
			fis = new FileInputStream(file);
		} catch (FileNotFoundException e) {
			_GroupDatas=new HashMap();
			_Datas=new HashMap();
			_GroupDatas.put(_DateStr,_Datas);
			return;
		}
		ObjectInputStream oiStream=new ObjectInputStream(fis);
		try {
			_GroupDatas=(Map)oiStream.readObject();
		} catch (Exception e) {
			_GroupDatas=new HashMap();
		}
		_Datas=(Map)_GroupDatas.get(_DateStr);
		if(_Datas==null){
			_Datas=new HashMap();
		}
		oiStream.close();
		fis.close();
	}
}
