/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.shedule;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
/*
 * 
 * Thanks@http://www.is.akita-u.ac.jp/~sig/
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */

public class JpCalendar {
	private static int SECOND_MONDAY = -2;
	private static int THIRD_MONDAY = -3;
	private static int VERNAL_DAY = -4;
	private static int AUTUM_DAY = -5;
	private static Collection _HolyDayTable;
	

	private Map _HolidaysTable=new HashMap();
	private int _Year;
	public JpCalendar(int year) {
		if(_HolyDayTable==null){
			_HolyDayTable=new ArrayList();
			_HolyDayTable.add(new HolyDay(1949,9999,1,1,""));
			_HolyDayTable.add(new HolyDay(1872,1949,1,3,"n(O)"));
			_HolyDayTable.add(new HolyDay(1872,1949,1,5,"VN(O)"));
			_HolyDayTable.add(new HolyDay(1967,2000,1,15,"l̓"));
			_HolyDayTable.add(new HolyDay(2000,9999,1,SECOND_MONDAY,"l̓"));
			_HolyDayTable.add(new HolyDay(1872,1913,1,30,"FVc()"));
			_HolyDayTable.add(new HolyDay(1872,1949,2,11,"LO"));
			_HolyDayTable.add(new HolyDay(1967,9999,2,11,"LO"));
			_HolyDayTable.add(new HolyDay(1876,9999,3,VERNAL_DAY,"t̓"));
			_HolyDayTable.add(new HolyDay(1872,1949,4,3,"_Vc(O)"));
			_HolyDayTable.add(new HolyDay(1927,1973,4,29,"Vca"));
			_HolyDayTable.add(new HolyDay(1973,9999,4,29,"݂ǂ̓"));
			_HolyDayTable.add(new HolyDay(1949,9999,5,3,"@LO"));
			_HolyDayTable.add(new HolyDay(1986,9999,5,4,"̋x"));
			_HolyDayTable.add(new HolyDay(1949,9999,5,5,"ǂ̓"));
			_HolyDayTable.add(new HolyDay(1996,2003,7,20,"C̓"));
			_HolyDayTable.add(new HolyDay(2003,9999,7,THIRD_MONDAY,"C̓"));
			_HolyDayTable.add(new HolyDay(1913,1927,7,30,"Vc(吳)"));
			_HolyDayTable.add(new HolyDay(1913,1927,8,30,"V(吳)"));
			_HolyDayTable.add(new HolyDay(1966,2003,9,15,"hV̓"));
			_HolyDayTable.add(new HolyDay(2003,9999,9,THIRD_MONDAY,"hV̓"));
			_HolyDayTable.add(new HolyDay(1876,9999,9,AUTUM_DAY,"H̓"));
			_HolyDayTable.add(new HolyDay(1966,2000,10,10,"̈̓"));
			_HolyDayTable.add(new HolyDay(2000,9999,10,SECOND_MONDAY,"̈̓"));
			_HolyDayTable.add(new HolyDay(1872,1877,9,17,"_"));
			_HolyDayTable.add(new HolyDay(1877,1948,10,17,"_"));
			_HolyDayTable.add(new HolyDay(1913,1927,10,31,"Vߏj"));
			_HolyDayTable.add(new HolyDay(1871,1912,11,3,"̓"));
			_HolyDayTable.add(new HolyDay(1973,9999,11,3,"̓"));
			_HolyDayTable.add(new HolyDay(1871,9999,11,23,"ΘJӂ̓"));
			_HolyDayTable.add(new HolyDay(1989,9999,12,23,"Vca"));
			_HolyDayTable.add(new HolyDay(1927,1948,12,25,"吳Vc(aO)"));
			_HolyDayTable.add(new HolyDay(1959,1960,4,10,"me̋V"));
			_HolyDayTable.add(new HolyDay(1989,1990,2,24,"aVcr̗"));
			_HolyDayTable.add(new HolyDay(1990,1991,11,12,"ʂ̋V"));
			_HolyDayTable.add(new HolyDay(1993,1994,6,9,"me̋V"));
			_HolyDayTable.add(new HolyDay(1915,1916,11,10,"Ȏ"));
			_HolyDayTable.add(new HolyDay(1915,1916,11,14,"Ȏ"));
			_HolyDayTable.add(new HolyDay(1915,1916,11,16,"Ȏ"));
			_HolyDayTable.add(new HolyDay(1928,1929,11,10,"Ȏ"));
			_HolyDayTable.add(new HolyDay(1928,1929,11,14,"Ȏ"));
			_HolyDayTable.add(new HolyDay(1928,1929,11,16,"Ȏ"));
		}
		_Year=year;
		_HolidaysTable = getHolidaysInYear();
	}

	/*
	 * http://homepage1.nifty.com/gyouseinet/kyujitsu.htm
	 *
	 */
	private Map getHolidaysInYear() {
		
		
		Map yearTable = new HashMap();
		for (Iterator iter = _HolyDayTable.iterator(); iter.hasNext();) {
			HolyDay holyDay = (HolyDay) iter.next();
			if(holyDay.isHolyDay(_Year)){
				Date dd=holyDay.getHolyDay(_Year);
				yearTable.put(dd.toString(),holyDay.getHolyDayName());
				if(_Year > 1973 && dd.isSunday()){
					yearTable.put(dd.nextDate().toString(),"U");
					
				}
			}
		}

		return yearTable;
	}
	public boolean isHolyday(int month, int day) {
		Date dd=new Date(_Year,month,day);
		return _HolidaysTable.containsKey(dd.toString());
	}
	public String getHolidayName(int month, int day) {
		Date dd=new Date(_Year,month,day);
		String name=(String)_HolidaysTable.get(dd.toString());
		if(name==null){
			return "";
		}else{
			return name;
		}
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public int getYear() {
		return _Year;
	}


	private class HolyDay {
		private int _SYear,_EYear,_Month,_Date;
		String _Name;
		HolyDay(int sYear,int eYear,int month,int date,String name){
			_SYear=sYear;
			_EYear=eYear;
			_Month=month;
			_Date=date;
			_Name=name;
		}
		boolean isHolyDay(int year){
			return(_SYear<=year && year< _EYear);
		}
		Date getHolyDay(int year){
			
			return new Date(year,_Month,_Date);
		}
		String  getHolyDayName(){
			return _Name;
		}
	}
	private class Date {

		private int _Year;
		private int _Month;
		private int _Day;

		Date(int year, int month, int date) {
			_Year = year;
			_Month = month;
			if (date == SECOND_MONDAY){
				_Day = secondMonday(year, month);
			}else if (date == THIRD_MONDAY){
				_Day = thirdMonday(year, month);
			}else if (date == VERNAL_DAY){
				_Day = getVernalEquinox(year);
			}else if (date == AUTUM_DAY){
				_Day = getAutumnalEquinox(year);
			}else{
				_Day = date;
			}
		}

		public boolean isSunday() {
			Calendar cal =Calendar.getInstance();
			cal.set(_Year, _Month-1, _Day);
			return cal.get(Calendar.DAY_OF_WEEK)==Calendar.SUNDAY;
		}
		public Date nextDate() {
			Date dd=new Date(_Year, _Month, _Day+1);
			return dd;
		}

		/* ( Javadoc)
		 * @see java.lang.Object#toString()
		 */
		public String toString() {
			StringBuffer sb=new StringBuffer();
			sb.append(_Year);
			if(_Month<=9){
				sb.append("0");
			}
			sb.append(_Month);
			if(_Day<=9){
				sb.append("0");
			}
			sb.append(_Day);
			return sb.toString();
		}

		/*
		 * {ɂt_̒ʉߓ (1850N2150N܂)
		 *
		 * vŹuݕ֗vPЌt(1983)QƂB
		 *
		 * ̋xƂĂ̏t̓́AON2t̊(V)
		 * ɂ茈肷B
		 */
		private int getVernalEquinox(int year) {
			if (year <= 1850) {
				throw new RuntimeException("Not Supoort Year:"+year);
			} else if (year < 1900) {
				return (int) (19.8277 + 0.242194 * (year - 1980) - (year - 1983) / 4);
			} else if (year < 1980) {
				return  (int) (20.8357 + 0.242194 * (year - 1980) - (year - 1983) / 4);
			} else if (year < 2100) {
				return  (int) (20.8431 + 0.242194 * (year - 1980) - (year - 1980) / 4);
			} else if (year <= 2150) {
				return  (int) (21.8510 + 0.242194 * (year - 1980) - (year - 1980) / 4);
			} else /* if (2150 < year) */ {
				throw new RuntimeException("Not Supoort Year:"+year);
			}
		}

		/*
		 * {ɂH_̒ʉߓ (1850N2150N܂)
		 *
		 * vŹuݕ֗vPЌt(1983)QƂ
		 *
		 * ̋xƂĂ̏H̓́AON2t̊(V)
		 * ɂ茈肷B
		 */
		private int getAutumnalEquinox(int year) {
			if (year <= 1850) {
				throw new RuntimeException("Not Supoort Year:"+year);
			}
			if (year < 1900) {
				return (int) (22.2588 + 0.242194 * (year - 1980) - (year - 1983) / 4);
			} else if (year < 1980) {
				return (int) (23.2588 + 0.242194 * (year - 1980) - (year - 1983) / 4);
			} else if (year < 2100) {
				return (int) (23.2488 + 0.242194 * (year - 1980) - (year - 1980) / 4);
			} else if (year <= 2150) {
				return (int) (24.2488 + 0.242194 * (year - 1980) - (year - 1980) / 4);
			} else /* if (2150 < year) */ {
				throw new RuntimeException("Not Supoort Year:"+year);
			}
		}

		private int secondMonday(int year, int month) {
			return (7 - getDayOfWeek(year, month, 7)) % 7 + 8;
			/* This expression is just a little magic.
			 * Verify 7 patterns instead to prove over modulo algebra.
			 */
		}

		private int thirdMonday(int year, int month) {
			return (7 - getDayOfWeek(year, month, 7)) % 7 + 15;
		}

		private int getDayOfWeek(int year, int month, int date) {
			int[] b = { 2, 5, 0, 3, 5, 1, 4, 6, 2, 4, 0, 3 };
			/* week number on 0th in each month from March to Feburuay */

			/* It is acceptable that month == 13 or 14 */
			if (month < 1 || 14 < month){
				throw new IndexOutOfBoundsException("Month: " + month);
			}

			if (month == 1 || month == 2) {
				month += 12;
				year -= 1;
			}
			return (year + year / 4 - year / 100 + year / 400 + b[month - 3] + date) % 7;
		}
	}
}

