/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.shedule;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import org.apache.commons.beanutils.BeanUtils;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.ObjectComparator;
import com.ponpo.portal.util.Validator;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionData4Const;
import com.ponpo.taglib.PlainData;
import com.ponpo.taglib.SelectData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class TaskEntry extends EventPortletAction implements PlainData,IterateData,SelectData{
	Map _RequestDat=new HashMap();
	TaskInfoManager _TaskInfoManager;
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#setData(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		_TaskInfoManager=new TaskInfoManager(req.getRemoteUser());
		Enumeration enum=req.getParameterNames() ;
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestDat.put(key,value);
			}
		}

	}
	public void displayExecDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
	}
	public void displayInitUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
		TaskInfo taskInfo=_TaskInfoManager.getTaskInfo((String)_RequestDat.get("taskId"));
		try {
			_RequestDat.putAll(BeanUtils.describe(taskInfo));
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}
	public void displayInitDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitUpd(req,res,entry);
	}
	public void validateDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		String value;
		value=(String)_RequestDat.get("tital");
		if(Validator.checkEmpty(value)){
				_ValidateError.setMsg("^Cg͕K{͂łB");	
		}
		value=(String)_RequestDat.get("limitDate");
		if(Validator.checkEmpty(value)){
		}else{
			if(!Validator.checkDateFormat(value,"yyyy/MM/dd")){
				_ValidateError.setMsg("̓t`słB");	
			}
		}
	}
	public void validateDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
	}
	public void logicAdd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{
		TaskInfo taskInfo =new TaskInfo();
		try {
			BeanUtils.populate(taskInfo,_RequestDat);
			_TaskInfoManager.setTaskInfo(taskInfo);
		} catch (IllegalAccessException e) {
			throw new PortalException(e);
		} catch (InvocationTargetException e) {
			throw new PortalException(e);
		}
	}
	public void logicUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{
		TaskInfo taskInfo=_TaskInfoManager.getTaskInfo((String)_RequestDat.get("taskId"));
		if(taskInfo==null){
			return;
		}
		try {
			BeanUtils.populate(taskInfo,_RequestDat);
			_TaskInfoManager.setTaskInfo(taskInfo);
		} catch (IllegalAccessException e) {
			throw new PortalException(e);
		} catch (InvocationTargetException e) {
			throw new PortalException(e);
		}
	}
	public void logicDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{
		TaskInfo taskInfo=_TaskInfoManager.getTaskInfo((String)_RequestDat.get("taskId"));
		if(taskInfo==null){
			return;
		}
		_TaskInfoManager.removeTaskInfo( taskInfo);
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) {
		return (String)_RequestDat.get(key);
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req, String reqKey) throws JspException {
		Collection col =new TreeSet(new ObjectComparator("limitDate")); 
		for (Iterator iter = _TaskInfoManager.getTask(); iter.hasNext();) {
			col.add( iter.next());
		}
		return col;
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getSelectValue(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getSelectValue(HttpServletRequest req, String key) throws JspException {
		return (String)_RequestDat.get(key);
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getOptions(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public OptionData[] getOptions(HttpServletRequest req, String key) throws JspException {
		if(key.equals("priority")){
			return OptionData4Const.getOptionsOneValue("1,2,3,4,5,6,7,8,9");
		}else if(key.equals("status")){
			return OptionData4Const.getOptionsTwoValue("VK,0,is,1,,2");
		}
		return null;
	}


}
