/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.shedule;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class TaskInfo implements Serializable{
	private String _TaskID;
	private String _Tital;
	private Date _LimitDate;
	private Integer _Priority;
	private Integer _Status;
	private String _Description;
	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getDescription() {
		return _Description;
	}
	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setDescription(String string) {
		_Description = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getLimitDate() {
		if(_LimitDate==null){
			return "";
		}
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
		
		return format.format(_LimitDate);
	}
	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setLimitDate(String string) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
		try {
			_LimitDate=format.parse(string);
		} catch (ParseException e) {
			;
		}
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public Integer getPriority() {
		return _Priority;
	}
	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setPriority(Integer string) {
		_Priority = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public Integer getStatus() {
		return _Status;
	}

	public String getDispStatus() {
		if(_Status==null){
			return "";
		}
		switch (_Status.intValue()) {
			case 0 :
				return "VK";
			case 1 :
				return "is";
			case 2 :
				return "";

			default :
				return "";
		}
		
	}
	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setStatus(Integer string) {
		_Status = string;
	}


	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getTaskID() {
		return _TaskID;
	}
	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setTaskID(String string) {
		_TaskID = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getTital() {
		return _Tital;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setTital(String string) {
		_Tital = string;
	}

}
