/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.shedule;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.util.Environment;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class TaskInfoManager {
	private String _UserID;
	private Map _Datas;
	public TaskInfoManager(String userID) throws PortalException{
		_UserID=userID;
		if(_UserID==null){
			_UserID="guest";
		}
		try {
			load();
		} catch (IOException e) {
			throw new PortalException(e);
		} catch (ClassNotFoundException e) {
			throw new PortalException(e);
		}

	}
	public Iterator getTask(){
		Collection col=new ArrayList();
		for (Iterator iter = _Datas.keySet().iterator(); iter.hasNext();) {
			String taskId = (String) iter.next();
			if(!taskId.equals("nextId")){
				col.add(_Datas.get(taskId));
			}
		}
		return col.iterator();
	}
	public void removeTaskInfo(TaskInfo taskInfo) throws PortalException{
		_Datas.remove(taskInfo.getTaskID());
		try {
			save();
		} catch (IOException e) {
			throw new PortalException(e);
		} catch (ClassNotFoundException e) {
			throw new PortalException(e);
		}
	}
	public TaskInfo getTaskInfo(String taskId){
		return (TaskInfo)_Datas.get(taskId);
	}
	public void setTaskInfo(TaskInfo taskInfo) throws PortalException{
		String taskId=taskInfo.getTaskID();
		if(taskId==null){
			Long nextId=(Long)_Datas.get("nextId");
			if(nextId==null){
				nextId=new Long(0);
			}
			taskInfo.setTaskID(nextId.toString());
			_Datas.put("nextId",new Long(nextId.longValue()+1L));
		}
		_Datas.put(taskInfo.getTaskID(),taskInfo);
		try {
			save();
		} catch (IOException e) {
			throw new PortalException(e);
		} catch (ClassNotFoundException e) {
			throw new PortalException(e);
		}
	}
	private void save() throws IOException, ClassNotFoundException{
		File file=Environment.getRealPath("WEB-INF/data/schedule/task");
		file=new File (file,_UserID);
		FileOutputStream fos=new FileOutputStream(file);
		ObjectOutputStream oiStream=new ObjectOutputStream(fos);
		oiStream.writeObject(_Datas);
		oiStream.close();
		fos.close();
	}
	private void load()throws IOException, ClassNotFoundException{
		File file=Environment.getRealPath("WEB-INF/data/schedule/task");
		file=new File (file,_UserID);
		FileInputStream fis;
		try {
			fis = new FileInputStream(file);
		} catch (FileNotFoundException e) {
			_Datas=new HashMap();
			return;
		}
		ObjectInputStream oiStream=new ObjectInputStream(fis);
		_Datas=(Map)oiStream.readObject();
		oiStream.close();
		fis.close();
	}
}
