/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.style.entry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.PortletStyle;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.portal.util.Validator;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.PlainData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class StyleEntry extends EventPortletAction implements  PortletAction,PlainData,IterateData{

	private Map _RequestDat=new HashMap();

	/**
	 * \f[^쐬iʏjB<BR>
	 * <PRE>
	 * \f[^쐬܂iʏjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {


		Enumeration enum=req.getParameterNames() ;

		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestDat.put(key,value);
			}
		}

		String actionName = RequestUtils.getActionName(req);
		if (actionName == null) {
			actionName = "none";
		}
		_RequestDat.put("entryAction", actionName);

	}
	public void displayExecDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);

	}
	/**
	 * \f[^쐬iXVjB<BR>
	 * <PRE>
	 * \f[^쐬܂iXVjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		if(_RequestDat.get("type").equals("actionDefine")){
			PortletStyle portletStyle=(PortletStyle)portletManager.getPortletStyle((String)_RequestDat.get("sytleId"));
			_RequestDat.put("sytleId",portletStyle.getSytleId());
			_RequestDat.put("sytleName",portletStyle.getSytleName());
			_RequestDat.put("sytleActionClass",portletStyle.getSytleActionClass());
		}else{
			PortletStyle portletStyle=(PortletStyle)portletManager.getPortletStyle((String)_RequestDat.get("sytleId"));
			_RequestDat.put("name",_RequestDat.get("name"));
			_RequestDat.put("value",portletStyle.getParam((String)_RequestDat.get("name")));
		}

	}
	public void displayInitDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitUpd(req,res,entry);
	}
	/**
	 * ǉs̓̓`FbNB<BR>
	 * <PRE>
	 * ǉs̓̓`FbNs܂B<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void validateAdd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{

		String value;
		if(_RequestDat.get("type").equals("actionDefine")){
			value=(String)_RequestDat.get("sytleId");
			if(Validator.checkEmpty(value)){
				_ValidateError.setMsg("ID͕K{ł");	
			}else{
				if(Validator.checkNotAlphanumericPlus(value,"_-")){
					_ValidateError.setMsg("ID͉pł");	
				}
			}		
			value=(String)_RequestDat.get("sytleName");
			if(Validator.checkEmpty(value)){
				_ValidateError.setMsg("O͕K{ł");	
			}		
		}else{
			value=(String)_RequestDat.get("name");
			if(Validator.checkEmpty(value)){
				_ValidateError.setMsg("O͕K{ł");	
			}else{
				if(Validator.checkNotAlphanumericPlus(value,"_-")){
					_ValidateError.setMsg("O͉pł");	
				}
			}		
		}

	}
	public void validateUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{
		validateAdd(req,res,entry);
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#logic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void logicAdd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		try {
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			if(_RequestDat.get("type").equals("actionDefine")){
				
				PortletStyle portletStyle=portletManager.newPortletStyle((String)_RequestDat.get("sytleId"));
				portletStyle.setName((String)_RequestDat.get("sytleName"));
				portletStyle.setStyleClass((String)_RequestDat.get("sytleActionClass"));

			}else{
				PortletStyle portletStyle=(PortletStyle)portletManager.getPortletStyle((String)_RequestDat.get("sytleId"));
				portletStyle.addParam((String)_RequestDat.get("name"),(String)_RequestDat.get("value"));
			}
			save();
		} catch (Exception e) {
			throw new PortalException(e);
		}
		
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#logic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void logicDel(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {

		try {
			displayInitDefault(req,res,entry);
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			PortletStyle portletStyle=(PortletStyle)portletManager.getPortletStyle((String)_RequestDat.get("sytleId"));
			if(_RequestDat.get("type").equals("actionDefine")){
				portletManager.removePortletStyle(portletStyle);
			}else{
				portletStyle.removeParam((String)_RequestDat.get("name"));
			}
			save();
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}
	public void logicUpd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		try {
			displayInitDefault(req,res,entry);
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			if(_RequestDat.get("type").equals("actionDefine")){
				PortletStyle portletStyle=(PortletStyle)portletManager.getPortletStyle((String)_RequestDat.get("sytleId"));
				portletStyle.setName((String)_RequestDat.get("sytleName"));
				portletStyle.setStyleClass((String)_RequestDat.get("sytleActionClass"));
			}else{
				PortletStyle portletStyle=(PortletStyle)portletManager.getPortletStyle((String)_RequestDat.get("sytleId"));
				portletStyle.addParam((String)_RequestDat.get("name"),(String)_RequestDat.get("value"));
			}
			save();
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) throws JspException {
		return (String)_RequestDat.get(key);
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req,String key) throws JspException {
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");

		Collection col=new ArrayList();
		try {
			for (Iterator iter = portletManager.getPortletStyleKeys(); iter.hasNext();) {
				String defineKey=(String)iter.next();
				PortletStyle portletStyle=(PortletStyle)portletManager.getPortletStyle(defineKey);
				Map map=new HashMap();
				map.put("sytleId",portletStyle.getSytleId());
				map.put("sytleName",portletStyle.getSytleName());
				map.put("sytleActionClass",portletStyle.getSytleActionClass());
				Collection paramCol=new ArrayList();
				for (Iterator iterator = portletStyle.getParamKeys(); iterator.hasNext();) {
					String paramKey=(String)iterator.next();
					Map paramMap=new HashMap();
					paramMap.put("name",paramKey);
					paramMap.put("value",portletStyle.getParam(paramKey));
					paramCol.add(paramMap);
				}
				map.put("params",paramCol.iterator());
				col.add(map);
			}
		} catch (PortalException e) {
			throw new JspException(e.getCause());
		}
		return col;
	}

	private void save() throws PortalException{
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		portletManager.savePortletStyle();
	}

}
