/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.wiki.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortalUtils;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.SecurityManager;
import com.ponpo.portal.UserManager;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.req.parser.RequestDecoder;
import com.ponpo.portal.util.Environment;
import com.ponpo.portal.util.FileUtils;
import com.ponpo.portal.util.StringUtils;
import com.ponpo.taglib.Filter;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionDataImpl;
import com.ponpo.taglib.PlainData;
import com.ponpo.taglib.SelectData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class WikiAction extends EventPortletAction implements PlainData,SelectData{
	protected Map _RequestMap=new HashMap();

	private String _MyURL;
	private String _Encode;
	private HttpServletResponse _Response;
	private HttpServletRequest _Request;

	private void doDisplay(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		_MyURL=PortletSystemDataUtils.getURL(entry);
		_Request=req;
		_Response=res;
		_Encode=req.getCharacterEncoding();
		Enumeration enum=req.getParameterNames() ;
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestMap.put(key,value);
			}
		}
		if(_RequestMap.get("page")!=null){
			RequestDecoder RequestDecoder=new RequestDecoder(req);
			_RequestMap.put("page",RequestDecoder.getParameter("page"));
		}
	}
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {


		try {
			doDisplay(req,res,entry);
			parseWiki(req,res,true,entry);
		} catch (IOException e) {
			throw new PortalException(e);
		}
		_RequestMap.put("entryAction", "wiki");

	}
	public void displayInitUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		try {
			doDisplay(req,res,entry);
			parseWiki(req,res,false,entry);
		} catch (IOException e) {
			throw new PortalException(e);
		}
		_RequestMap.put("entryAction", "upd");
	}
	public void displayExecUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		_MyURL=PortletSystemDataUtils.getURL(entry);
		_Response=res;
		Enumeration enum=req.getParameterNames() ;
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestMap.put(key,value);
			}
		}
	}
	public void logicUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {

		
		try {
			File makefile=Environment.getRealPath( "/WEB-INF/data/wiki/"+entry.getStrParam("node")+"/"+getPage(entry));
			String data=(String)_RequestMap.get("wikiData");
			if(data==null||data.length()==0){
				FileUtils.treeDel(makefile);
				return;
			}
			
			makefile.getParentFile().mkdirs();
			FileOutputStream fout= new FileOutputStream(makefile);
			OutputStreamWriter write=new OutputStreamWriter(fout,"utf-8");
			String buff;
			if(_RequestMap.get("readRole")!=null){
				buff="##READ_ROLE:"+_RequestMap.get("readRole")+"\n";
				write.write(buff);
			}
			if(_RequestMap.get("editRole")!=null){
				buff="##EDIT_ROLE:"+_RequestMap.get("editRole")+"\n";
				write.write(buff);
			}
			write.write(data);
			write.close();
			fout.close();
		} catch (IOException e) {
			throw new  PortalException(e);
		}
		
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) throws JspException {
			return (String)_RequestMap.get(key);
	}
	public OptionData[] getOptions(HttpServletRequest req, String key) throws JspException {
		Collection col=new ArrayList();
		try{
			col.add(new OptionDataImpl("wȂ",""));
			if(req.getRemoteUser()!=null){
				col.add(new OptionDataImpl("vCx[g","##"+req.getRemoteUser()));
			}

			UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
			for (Iterator iter = userManager.getRoles(); iter.hasNext();) {
				String role = (String) iter.next();

				col.add(new OptionDataImpl(role,role));
			}
			
			return (OptionDataImpl[])col.toArray(new OptionDataImpl[0]);
		}catch(PortalException e){
			throw new JspException(e.getCause());
		}
	}
	public String getSelectValue(HttpServletRequest req, String key) throws JspException {
		return (String)_RequestMap.get(key);
	}

	private void parseWiki(HttpServletRequest req,HttpServletResponse res,boolean convert,PortletItem entry) throws IOException {
		if(entry.getStrParam("node")==null){
			_RequestMap.put("wikiData","p[^nodeKvłB");
			return ;

		}
		if(getPage(entry)==null){
			_RequestMap.put("wikiData","p[^pageKvłB");
			return ;
		}
		File makefile=Environment.getRealPath("/WEB-INF/data/wiki/"+entry.getStrParam("node")+"/"+getPage(entry));
		BufferedReader in=null;
		try {
			in = new BufferedReader(new InputStreamReader(new FileInputStream(makefile),"utf-8"));
		} catch (FileNotFoundException e) {
			_RequestMap.put("wikiData",entry.getStrParam("node")+"/"+getPage(entry)+"܂");
		}
		if(in==null){
			PortalUtils.setOplations(
				entry,
				req.getContextPath()+"/images/l_edit.gif",
				PortletSystemDataUtils.getURL(entry)+"?ACT=upd");
			return;
		}
		String buffer;
		blockquoteCnt=0;

		buffer=in.readLine();
		if(buffer!=null){
			if(buffer.startsWith("##READ_ROLE:")){
				if(buffer.length()>12){
					_RequestMap.put("readRole",buffer.substring(12));
				}
				buffer=in.readLine();
			}
		}
		if(buffer!=null){
			if(buffer.startsWith("##EDIT_ROLE:")){
				if(buffer.length()>12){
					_RequestMap.put("editRole",buffer.substring(12));
				}
				buffer=in.readLine();
			}
		}
		SecurityManager securityManager=(SecurityManager)ContextManager.lookupImplementer("com.ponpo.portal.SecurityManager");
		if(!securityManager.isEnabled(req,res,(String)_RequestMap.get("readRole"))){
			_RequestMap.put("wikiData","̃f[^ɑ΂ǂݍ݌܂");
			return;
		}
		if(_RequestMap.get("editRole")==null || securityManager.isEnabled(req,res,(String)_RequestMap.get("editRole"))){
			PortalUtils.setOplations(
			entry,
			req.getContextPath()+"/images/l_edit.gif",
			PortletSystemDataUtils.getURL(entry)+"?ACT=upd");
		}

		StringBuffer sb=new StringBuffer(); 
		if(convert){
			sb.append(("<div class=\"wiki\">\n"));
			sb.append("<H1>");
			sb.append(getPage(entry));
			sb.append("</H1>\n");
		}
		while(buffer!=null){
			if(convert){
				sb.append(parseLine(buffer));
			}else{
				sb.append(Filter.doFilter(buffer));
				sb.append("\n");
			}
			buffer=in.readLine();
		}
		if(convert){
			sb.append(clearTag(""));
			sb.append(("</div>\n"));
		}
		_RequestMap.put("wikiData",sb.toString());
		in.close();
		in=null;
 
	}
	private String getPage(PortletItem entry){
		String page=(String)_RequestMap.get("page");
		if(page==null){
			page=entry.getStrParam("page");
		}
		return page;
	}
	private int blockquoteCnt=0;
	private int olCnt=0;
	private int ulCnt=0;
	private int dlCnt=0;
	private int tableCnt=0;
	private boolean HtmlFlag=false;
	private boolean PREFlag=false;
	private boolean P_Flag=false;
	private String parseLine(String orgLine ){
		StringBuffer rtn=new StringBuffer();
		if(orgLine.startsWith("<%")){
			HtmlFlag=true;
			return "";
		}else if(orgLine.startsWith("%>")){
			HtmlFlag=false;
			return "";
		}
		if(HtmlFlag){
			return (convertHTMLKeyWord(orgLine)+"\n");
		}
		if(orgLine.startsWith("<#")){
			PREFlag=true;
			return("<pre>\n");
		}else if(orgLine.startsWith("#>")){
			PREFlag=false;
			return("</pre>\n");
		}
		if(PREFlag){
			return (Filter.doFilter(orgLine)+"\n");
		}

		rtn.append(clearTag(orgLine));
		if(orgLine.startsWith("----")){
			rtn.append("<hr class=\"sep\">");
		}else if(orgLine.startsWith(" ")){
			rtn.append(doBlockquote(orgLine));
			return rtn.toString();
		}else if(orgLine.startsWith("*")){
			rtn.append(doH(orgLine));
		}else if(orgLine.startsWith("//")){
		}else if(orgLine.startsWith("-")){
			rtn.append(doLI(orgLine,ulCnt,"ul","-"));
			ulCnt=getQtyMark(orgLine,"-");
		}else if(orgLine.startsWith("+")){
			rtn.append(doLI(orgLine,olCnt,"ol","+"));
			olCnt=getQtyMark(orgLine,"+");
		}else if(orgLine.startsWith("::")){
			rtn.append(doDL(orgLine));
		}else if(orgLine.startsWith(",")){
			rtn.append(doTABLE(orgLine));
		}else{
			if(orgLine.length()==0){
			}else{
				if(!P_Flag){
					rtn.append("<p>");
					P_Flag=true;
				}
				rtn.append(cnvLine(orgLine));
			}
			return rtn.toString();
		}
		rtn.append("\n");
		return rtn.toString();
	}
	private String clearTag(String orgLine){
		int status;
		StringBuffer rtn=new StringBuffer();
		if(orgLine.startsWith("//")){
			status=0;
		}else if(orgLine.startsWith("----")){
			status=0x111111;
		}else if(orgLine.startsWith(" ")){
			status=0x111101;
		}else if(orgLine.startsWith(",")){
			status=0x111011;
		}else if(orgLine.startsWith("+")){
			status=0x110111;
		}else if(orgLine.startsWith("-")){
			status=0x101111;
		}else if(orgLine.startsWith("::")){
			status=0x011111;
		}else if(orgLine.startsWith("*")){
			status=0x111111;
		}else{
			status=0x111110;
		}
		if((status&0x000100)!=0){
			if(tableCnt !=0){
				tableCnt=0;
				rtn.append("</table>\n");
			} 
		}
		if((status&0x000001)!=0){
			if(P_Flag){
				rtn.append("</p>\n");
				P_Flag=false;
			}
		}
		if((status&0x000010)!=0){
			if(P_Flag){
				rtn.append("</p>\n");
				P_Flag=false;
			}
			if(blockquoteCnt >0){ 
				blockquoteCnt=0;
				rtn.append("</blockquote>\n");
			}
		}
		if((status&0x001000)!=0){
			if(olCnt !=0){
				rtn.append(clearLI(orgLine,olCnt,"ol"));
				olCnt=0;
			}
		}
		if((status&0x010000)!=0){
			if(ulCnt !=0){
				rtn.append(clearLI(orgLine,ulCnt,"ul"));
				ulCnt=0;
			}
		}
		if((status&0x100000)!=0){
			if(dlCnt !=0){
				dlCnt=0;
				rtn.append("</dl>\n");
			}
		}

		return rtn.toString();
		
	}
	private String doH(String orgLine ){
		StringBuffer rtn=new StringBuffer();
		if( orgLine.startsWith("***" )){
			rtn.append ("<H4>"+cnvLine(orgLine.substring(3))+"</H4>");
		}else if( orgLine.startsWith("**" )){
			rtn.append ("<H3>"+cnvLine(orgLine.substring(2))+"</H3>");
		}else if( orgLine.startsWith("*" )){
			rtn.append ("<H2>"+cnvLine(orgLine.substring(1))+"</H2>");
		}
		return rtn.toString();
	}
	private String clearLI(String orgLine,int cnt,String kind ){
		if(cnt==0){
			return "";
		}
		StringBuffer rtn=new StringBuffer();
		String eWord="</"+kind+">";
		if(cnt==1){
			rtn.append(eWord);
			rtn.append("\n");
		}else if(cnt==2){
			rtn.append(eWord);
			rtn.append("\n");
			rtn.append(eWord);
			rtn.append("\n");
		}else if(cnt==3){
			rtn.append(eWord);
			rtn.append("\n");
			rtn.append(eWord);
			rtn.append("\n");
			rtn.append(eWord);
			rtn.append("\n");
		}
		return rtn.toString();
	}
	private String doTABLE(String orgLine ){
		StringBuffer rtn=new StringBuffer();
		String[] field=StringUtils.cnvComma2Array(orgLine.substring(1));
		String tag;
		if(tableCnt==0){
			rtn.append("<table>\n");
			tag="th";
			tableCnt=1;
		}else{
			tag="td";
		}
		rtn.append("<tr>\n");
		for (int cnt = 0; cnt < field.length; cnt++) {
			rtn.append("<");
			rtn.append(tag);
			rtn.append(">");
			rtn.append(cnvLine(field[cnt]));
			rtn.append("</");
			rtn.append(tag);
			rtn.append(">");
		}
		rtn.append("</tr>\n");
		return rtn.toString();
	}
	private int getQtyMark(String orgLine,String mark ){
		if( orgLine.startsWith(mark+mark+mark )){
			return 3;
		}else if( orgLine.startsWith(mark+mark )){
			return 2;
		}else if( orgLine.startsWith(mark )){
			return 1;
		}
		return 0;
	}
	private String doLI(String orgLine,int cnt,String kind ,String mark ){
		String sWord="<"+kind+">";
		String eWord="</"+kind+">";
		StringBuffer rtn=new StringBuffer();
		if( orgLine.startsWith(mark+mark+mark )){
			if(cnt==0){
				rtn.append(sWord);
				rtn.append(sWord);
				rtn.append(sWord);
			}else if(cnt==1){
				rtn.append(sWord);
				rtn.append(sWord);
			}else if(cnt==2){
				rtn.append(sWord);
			}else if(cnt==3){
			}
			rtn.append ("<li>"+cnvLine(orgLine.substring(2))+"</li>");
		}else if( orgLine.startsWith(mark+mark )){
			if(cnt==0){
				rtn.append(sWord);
				rtn.append(sWord);
			}else if(cnt==1){
				rtn.append(sWord);
			}else if(cnt==2){
			}else if(cnt==3){
				rtn.append(eWord);
			}
			rtn.append ("<li>"+cnvLine(orgLine.substring(2))+"</li>");
		}else if( orgLine.startsWith(mark )){
			if(cnt==0){
				rtn.append(sWord);
			}else if(cnt==1){
			}else if(cnt==2){
				rtn.append(eWord);
			}else if(cnt==3){
				rtn.append(eWord);
				rtn.append(eWord);
			}
			rtn.append ("<li>"+cnvLine(orgLine.substring(1))+"</li>");
		}
		return rtn.toString();
	}	

	private String doDL(String orgLine ){
		StringBuffer rtn=new StringBuffer();
		if(dlCnt ==0){
			rtn.append("<dl>");
		}
		if(orgLine.startsWith(":::")){	
			rtn.append("<dd>");
			rtn.append(cnvLine(orgLine.substring(3)));
			rtn.append("</dd>");
		}else if(orgLine.startsWith("::")){	
			rtn.append("<dt>");
			rtn.append(cnvLine(orgLine.substring(2)));
			rtn.append("</dt>");
		}
		dlCnt=1;
		return rtn.toString();
	}		
	private String doBlockquote(String orgLine ){
		StringBuffer rtn=new StringBuffer();
		if(blockquoteCnt ==0){
			blockquoteCnt=1; 
			rtn.append("<blockquote>");
		}
		if(!P_Flag){
			rtn.append("<p>");
			P_Flag=true;
		}
		rtn.append(cnvLine(orgLine.substring(1)));
		return rtn.toString();
	}		
	private String cnvLine(String orgLine){
		String line=Filter.doFilter(orgLine);
		while(line.indexOf("'''")!=-1){
			line=line.replaceFirst("'''","<em>");
			line=line.replaceFirst("'''","</em>");
		}
		while(line.indexOf("''")!=-1){
			line=line.replaceFirst("''","<strong>");
			line=line.replaceFirst("''","</strong>");
		}
		while(line.indexOf("==")!=-1){
			line=line.replaceFirst("==","<del>");
			line=line.replaceFirst("==","</del>");
		}
		while(line.indexOf("__")!=-1){
			line=line.replaceFirst("__","<ins>");
			line=line.replaceFirst("__","</ins>");
		}
		line=doLink(line);
		return line;
	}
	private String doLink(String orgLine){
		String line=orgLine;
		while(line.indexOf("[[")!=-1){
			int spos=line.indexOf("[[");
			int epos=line.indexOf("]]");
			int dpos=line.indexOf("|");
			if (epos==-1){
				break;
			}
			String label;
			String url;
			if(dpos!=-1 && dpos<epos){
				label=line.substring(spos+2,dpos);
				url=line.substring(dpos+1,epos);
			}else{
				label=line.substring(spos+2,epos);
				url=label;
			}
			if(url.indexOf("://")==-1){
				try {
					url=_Response.encodeRedirectURL(_MyURL+"?page="+URLEncoder.encode(url,_Encode));
				} catch (UnsupportedEncodingException e) {
					;
				}
			}
			StringBuffer sb=new StringBuffer();
			sb.append(line.substring(0,spos));
			sb.append("<a href=\"");
			sb.append(url);
			sb.append("\">");
			sb.append(label);
			sb.append("</a>");
			sb.append(line.substring(epos+2));
			line=sb.toString();
		}
		return line;	
	}
	private String _KeyWord_UserID; 
	private String _KeyWord_Home; 
	private String convertHTMLKeyWord( String line){
		String rtn=line;
		if(_KeyWord_Home==null){
			_KeyWord_Home=_Request.getContextPath();
		}

		rtn=rtn.replaceAll("\\$\\{CONTEXT_PATH\\}",_KeyWord_Home);
		if(_KeyWord_UserID==null){
			_KeyWord_UserID=_Request.getRemoteUser();
			if(_KeyWord_UserID==null){
				_KeyWord_UserID="";
			}
		}
		rtn=rtn.replaceAll("\\$\\{USER_ID\\}",_KeyWord_UserID);
		return rtn;
	}
		
}
