/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.wiki.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ForwardingURL;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.Environment;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.PlainData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class WikiSearch extends EventPortletAction implements PlainData,IterateData,ForwardingURL{

	private String _Node;
	private String _Url;
	private Map _RequestMap=new HashMap();
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#setData(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		if(entry.getStrParam("node")==null){
			_RequestMap.put("msg","p[^Ƀm[hKvłB");
			return ;
		}
		_Node=entry.getStrParam("node");
		_Url=PortletSystemDataUtils.getURL(entry);
	}
	public void displayExecDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		if(entry.getStrParam("node")==null){
			_RequestMap.put("msg","p[^Ƀm[hKvłB");
			return ;
		}
		_Node=entry.getStrParam("node");
		_Url=PortletSystemDataUtils.getURL(entry);
		_RequestMap.put("word",req.getParameter("word"));
	}
	private Collection _SearchData=new ArrayList();
	public void logicDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		File path=Environment.getRealPath("WEB-INF/data/wiki/"+_Node);
		File files[]=path.listFiles();
		String word=req.getParameter("word");
		if(word==null||word.length()==0){
			return;
		}
		if(files!=null){
			for (int cnt = 0; cnt < files.length; cnt++) {
				Collection col;
				try {
					col= grep(files[cnt], word);
				} catch (IOException e1) {
					break;
				}
				if(!col.isEmpty()){
					Map map=new HashMap();
					_SearchData.add(map);
					map.put("subData",col);
					map.put("pageName",files[cnt].getName());
					String url=null;
					try {
						url =_Url+ "/wiki?page="+ URLEncoder.encode(files[cnt].getName(), req.getCharacterEncoding());
					} catch (UnsupportedEncodingException e) {
					}
					map.put("url",url);
				}
			}
			_RequestMap.put("havaData",String.valueOf(!_SearchData.isEmpty()));

		}

	}

	private Collection grep(File file ,String pattern) throws IOException {
		String lineData;
		BufferedReader d= new BufferedReader(new InputStreamReader(new FileInputStream(file),"utf-8"));;
		Collection col= new ArrayList();
		while ((lineData= d.readLine())!=null) {
			if (lineData.indexOf(pattern)!=-1) {
				col.add(lineData);
			}
		}
		return col;
	  }
	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) {
		String value=(String)_RequestMap.get(key);
		return value;
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req, String key) throws JspException {
		return _SearchData;
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.ForwardingURL#getFrowardURLWhenExec(javax.servlet.http.HttpServletRequest)
	 */
	public String getFrowardURLWhenExec(HttpServletRequest req) {
		return null;
	}
}
