/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.skin;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortalUtils;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.SecurityManager;
import com.ponpo.portal.ValidateError;
import com.ponpo.portal.action.BasePortletAction;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.PlainData;


/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class MultiSkinAction extends  BasePortletAction implements PlainData,IterateData {
	private static Log log = LogFactory.getLog(MultiSkinAction.class);
	protected Map _OutPutMap=new HashMap();
	protected Map _ReadData=new HashMap();

	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#makeDisplayDate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void makeDisplayDate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
		String url;
		SecurityManager securityManager=(SecurityManager)ContextManager.lookupImplementer("com.ponpo.portal.SecurityManager");
		if(!securityManager.isReadEnabled(req,res,entry)){
			return;
		}

		for (Iterator iter = entry.getLeaf().iterator(); iter.hasNext();) {
			PortletItem leafItem = (PortletItem) iter.next();
			if(leafItem!=null){
				if(securityManager.isReadEnabled(req,res,leafItem)){
					Map map=new HashMap();
			
					boolean leafSelected=PortletSystemDataUtils.getSelected(leafItem);
					PortletAction action;

					try {
						action = leafItem.getActionInfo().getPortletAction();
						String contents=action.doView(req,res,leafItem);
						map.put("contents", contents);
					} catch (PortalException e) {
						map.put("contents",getExceptionFormat("PortletName="+leafItem.getPortletName(),e.getCause()) );
					}

					url=PortletSystemDataUtils.getURL(leafItem);
					map.put("selected", String.valueOf(leafSelected));
					map.put("url", url);
					map.put("label", leafItem.getLabel());

					_OutPutMap.put(leafItem.getId(),map);
				}
			}
		}
		url=PortletSystemDataUtils.getURL(entry);
		_ReadData.put("myURL", url);
		_ReadData.put("myLabel", entry.getLabel());
		_ReadData.put("myOperation", getOperation(req,res,entry,securityManager));
		for (Iterator iter = entry.getPortletParamKeys(); iter.hasNext();) {
			String key = (String) iter.next();
			_ReadData.put(key,entry.getPortletParam(key));
		}
	}
	protected String getExceptionFormat(String Message,Throwable t){
		log.fatal(Message,t );
		StringBuffer sb=new StringBuffer();
		StringWriter sw=new StringWriter();
		t.printStackTrace(new PrintWriter(sw));
		sb.append("<div class=\"message\">");
		sb.append("<h3>Exception </h3>");
		sb.append("Message:");
		sb.append(Message);
		sb.append("<pre>");
		sb.append(sw.toString());
		sb.append("</pre>");
		sb.append("</div>");
		return sb.toString();
	}
	protected String getOperation(HttpServletRequest req, HttpServletResponse res, PortletItem entry,SecurityManager securityManager){
		if(securityManager.isEditEnabled(req,res,entry)){
			PortalUtils.setOplations(
			entry,
			req.getContextPath()+"/images/portletEdit.gif",
			PortletSystemDataUtils.getURL(entry)+"/portlet_edit");
		}
		return PortalUtils.getOperation(entry);
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#initExec(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void initExec(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#validate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void validate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#doLogic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void doLogic(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getTagData(HttpServletRequest req, String key) throws JspException {
		return (String)_ReadData.get(key);
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req, String key) throws JspException {
		return null;
	}

}
