/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.UserManager;
import com.ponpo.portal.ValidateError;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionDataImpl;
import com.ponpo.taglib.PlainData;
import com.ponpo.taglib.SelectData;


/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortalTopAction extends  SingleSkinAction implements PlainData,IterateData,SelectData{


	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#makeDisplayDate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void makeDisplayDate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
		super.makeDisplayDate(req,res,entry);
		_ReadData.put("messageArea",makeMessage(entry));
	}
	private String makeMessage(PortletItem entry){
		Collection col=PortletSystemDataUtils.getErrorMsg(entry);
		if(col!=null){
			Iterator msgIterator=col.iterator();
			StringBuffer rtn = new StringBuffer();
			rtn.append("bZ[W");
			rtn.append("<UL>");
			while (msgIterator.hasNext()) {
				String value = (String) msgIterator.next();
				rtn.append("<LI>");
				rtn.append("<FONT color=\"red\">" + value + "</FONT>");
				rtn.append("</LI>");
				rtn.append("\n");
				
			}
			rtn.append("</UL>");
			PortletSystemDataUtils.setErrorMsg(entry,(Collection)null);
			return rtn.toString();
		}
		return "";
	}


	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#doLogic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void doLogic(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		if(req.getRemoteUser()==null){
			return;
		}
		UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
		userManager.setStartPortal(req.getRemoteUser(),req.getParameter("pageEntry"));
	}
	public String getSelectValue(HttpServletRequest req, String key) throws JspException {
		return null;
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getOptions(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public OptionData[] getOptions(HttpServletRequest req, String key) throws JspException {
		Collection col =new ArrayList();
		UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
		
		try {
			for (Iterator iter = userManager.getEnablePortals(req.getRemoteUser()); iter.hasNext();) {
				String element = (String) iter.next();
				col.add(new OptionDataImpl(element,element));
			}
		} catch (PortalException e) {
			throw new JspException("",e.getCause() );
		}
		return (OptionDataImpl[])col.toArray(new OptionDataImpl[0]);
	}

}
