/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.skin;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortalUtils;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletStyle;
import com.ponpo.portal.PortletStyleAction;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.SecurityManager;
import com.ponpo.portal.util.JspLoader;
import com.ponpo.taglib.DataManager;
import com.ponpo.taglib.PlainData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class StyleAction implements PortletStyleAction,PlainData {

	private Map _Map=new HashMap();
	public String doView(HttpServletRequest req, HttpServletResponse res,PortletItem entry,PortletStyle portletStle, String contens) throws PortalException {
		String url=PortletSystemDataUtils.getURL(entry);
		_Map.put("contents", contens);
		_Map.put("selected",String.valueOf(PortletSystemDataUtils.getSelected(entry)));
		_Map.put("url", url);
		_Map.put("label", entry.getLabel());
		_Map.put("operation",getOperation(req,res,entry));
		DataManager.setData(req,this);
		DataManager.setRequestURL(req,url);
		JspLoader jsp =new JspLoader();
		String contents;
		try {
			contents = jsp.doView(req, res, portletStle.getParam("jsp"));
		} catch (Exception e) {
			throw new PortalException(e);
		}
		return contents;

	}
	public String getTagData(HttpServletRequest req, String key) throws JspException {
		return (String)_Map.get(key);
	}
	protected String getOperation(HttpServletRequest req, HttpServletResponse res, PortletItem entry){
		SecurityManager securityManager=(SecurityManager)ContextManager.lookupImplementer("com.ponpo.portal.SecurityManager");
		if(securityManager.isEditEnabled(req,res,entry)){
			PortalUtils.setOplations(
			entry,
			req.getContextPath()+"/images/portletEdit.gif",
			PortletSystemDataUtils.getURL(entry)+"/portlet_edit");
		}
		return PortalUtils.getOperation(entry);
	}
}
