/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.skin.canvas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortalUtils;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.SecurityManager;
import com.ponpo.portal.ValidateError;
import com.ponpo.portal.skin.MultiSkinAction;
import com.ponpo.portal.util.StringUtils;


/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class Canvas extends  MultiSkinAction {
	private PortletItem _Entry;

	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#makeDisplayDate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void makeDisplayDate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
		_Entry=entry;
		SecurityManager securityManager=(SecurityManager)ContextManager.lookupImplementer("com.ponpo.portal.SecurityManager");
		if(securityManager.isEditEnabled(req,res,entry)){
			PortalUtils.setOplations(
			entry,
			req.getContextPath()+"/images/l_edit.gif",
			PortletSystemDataUtils.getURL(entry)+"/layout");
		}

		super.makeDisplayDate(req,res,entry);
		int allWidth=0;
		String value=_Entry.getStrParam("widthLeft");
		try {
			allWidth+=Integer.parseInt(value);
		} catch (NumberFormatException e) {
		}
		value=_Entry.getStrParam("widthCenter");
		try {
			allWidth+=Integer.parseInt(value);
		} catch (NumberFormatException e) {
		}
		value=_Entry.getStrParam("widthRight");
		try {
			allWidth+=Integer.parseInt(value);
		} catch (NumberFormatException e) {
		}
		
		_ReadData.put("allWidth",String.valueOf(allWidth));
	}
	public Object getIterator(HttpServletRequest req, String key) throws JspException {
		Collection col=new ArrayList();
		if(key.equals("left")){
			String leftData[]=StringUtils.cnvComma2Array(_Entry.getStrParam("dataLeft"));
			for (int cnt = 0; cnt < leftData.length; cnt++) {
				col.add(_OutPutMap.get(leftData[cnt]));
			}
			Collection noEntry=CanvasUtils.getNoEntryItem(_Entry);
			for (Iterator iter = noEntry.iterator(); iter.hasNext();) {
				String element = (String) iter.next();
				col.add(_OutPutMap.get(element));
			}

		}else if(key.equals("center")){
			String leftData[]=StringUtils.cnvComma2Array(_Entry.getStrParam("dataCenter"));
			for (int cnt = 0; cnt < leftData.length; cnt++) {
				col.add(_OutPutMap.get(leftData[cnt]));
			}
		}else if(key.equals("right")){
			String leftData[]=StringUtils.cnvComma2Array(_Entry.getStrParam("dataRight"));
			for (int cnt = 0; cnt < leftData.length; cnt++) {
				col.add(_OutPutMap.get(leftData[cnt]));
			}
		}
		return col;
	}

}
