/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.skin.canvas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortalUtils;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.UserManager;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.portal.util.StringUtils;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionDataImpl;
import com.ponpo.taglib.PlainData;
import com.ponpo.taglib.SelectData;


/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class CanvasLayout extends EventPortletAction implements  PortletAction,PlainData,SelectData{
	private Map _RequestDat=new HashMap();
	private PortletItem _Entry;
	/**
	 * \f[^쐬iʏjB<BR>
	 * <PRE>
	 * \f[^쐬܂iʏjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
		String portalName=userManager.getStartPortal(req.getRemoteUser());

		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		PortletItem topItem=portletManager.getPortal(portalName);

		String path=req.getPathInfo().substring(0,req.getPathInfo().length()-"/layout".length());

		_Entry=PortalUtils.lookupPortalItem(topItem,path);

		Enumeration enum=req.getParameterNames() ;

		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestDat.put(key,value);
			}
		}
		String actionName = RequestUtils.getActionName(req);
		if (actionName == null) {
			actionName = "none";
		}
		_RequestDat.put("entryAction", actionName);

	}
	public void displayExecDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
	}
	public void logicDefault(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		_Entry.addPortletParam("widthLeft",(String)_RequestDat.get("widthLeft"));
		_Entry.addPortletParam("widthCenter",(String)_RequestDat.get("widthCenter"));
		_Entry.addPortletParam("widthRight",(String)_RequestDat.get("widthRight"));
		_Entry.addPortletParam("visibleCenter",(String)_RequestDat.get("visibleCenter"));
		_Entry.addPortletParam("visibleRight",(String)_RequestDat.get("visibleRight"));
		_Entry.addPortletParam("dataLeft",getDefData((String)_RequestDat.get("dataLeft")));
		_Entry.addPortletParam("dataCenter",getDefData((String)_RequestDat.get("dataCenter")));
		_Entry.addPortletParam("dataRight",getDefData((String)_RequestDat.get("dataRight")));

		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
		portletManager.savePortal(userManager.getStartPortal(req.getRemoteUser()));
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getTagData(HttpServletRequest req, String key) throws JspException {
		return (String)_Entry.getParamData(key);
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getSelectValue(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getSelectValue(HttpServletRequest req, String key) throws JspException {
		return null;
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getOptions(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public OptionData[] getOptions(HttpServletRequest req, String key) throws JspException {
		String datas="";
		if(key.equals("boxLeft")){
			String leftData[]=StringUtils.cnvComma2Array((String)_Entry.getParamData("dataLeft"));
			Collection col=new ArrayList();
			for (int cnt = 0; cnt < leftData.length; cnt++) {
				col.add(leftData[cnt]);
			}
			col.addAll(CanvasUtils.getNoEntryItem(_Entry));
			return(getOptions((String[])col.toArray(new String[0])));
		}else if(key.equals("boxCenter")){
			datas=(String)_Entry.getParamData("dataCenter");
			return getOptions(datas);
		}else if(key.equals("boxRight")){
			datas=(String)_Entry.getParamData("dataRight");
			return getOptions(datas);
		}
		return null;
	}
	private String getDefData(String defStr){
		StringBuffer rtn=new StringBuffer();
		Collection col=getFilterNoDefineItem(StringUtils.cnvComma2Array(defStr));
		for (Iterator iter = col.iterator(); iter.hasNext();) {
			rtn.append( iter.next());
			rtn.append(",");
		}
		return(rtn.toString());
	}
	private OptionData[] getOptions(String items){
		return getOptions(StringUtils.cnvComma2Array(items));
	}
	private OptionData[] getOptions(String items[]){
		Collection rtn=new ArrayList();
		Collection col=getFilterNoDefineItem(items);
		for (Iterator iter = col.iterator(); iter.hasNext();) {
			String element = (String) iter.next();
			rtn.add(new OptionDataImpl(element,element));
		}
		return((OptionData[])rtn.toArray(new OptionDataImpl[0]));
		
	}
	private Collection getFilterNoDefineItem(String items[]){
		Collection rtn=new ArrayList();
		for (int cnt= 0; cnt < items.length; cnt++) {
			for (Iterator iter = _Entry.getLeaf().iterator(); iter.hasNext();) {
				PortletItem portletItem = (PortletItem) iter.next();
				if(items[cnt].equals(portletItem.getId())){
					rtn.add(items[cnt]);
					break;
				}
			}
		}
		return rtn;
	}

}
