/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.skin.canvas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import com.ponpo.portal.PortletItem;
import com.ponpo.portal.util.StringUtils;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class CanvasUtils {
	public static  Collection getNoEntryItem(PortletItem canvasItem){
		Collection rtn=new ArrayList();
		String leftItems[]=StringUtils.cnvComma2Array(canvasItem.getStrParam("dataLeft"));
		String centerItems[]=StringUtils.cnvComma2Array(canvasItem.getStrParam("dataCenter"));
		String righttems[]=StringUtils.cnvComma2Array(canvasItem.getStrParam("dataRight"));
		for (Iterator iter = canvasItem.getLeaf().iterator(); iter.hasNext();) {
			PortletItem portletItem = (PortletItem) iter.next();
			String portletId=portletItem.getId();
			if(getNoEntryItem(leftItems,centerItems,righttems,portletId)){
				rtn.add(portletId);
			}
		}
		return rtn;
	}
	
	private static boolean getNoEntryItem(String[] left,String[] center,String[] right,String value){
		if(getNoEntryItem(left,value)){
		}else if(getNoEntryItem(center,value)){
		}else if(getNoEntryItem(right,value)){
		}else{
			return true;
		}
		return false;

	}
	private static boolean getNoEntryItem(String[] values,String value){
		for (int cnt = 0; cnt < values.length; cnt++) {
			if(value.equals(values[cnt])){
				return true;
			}
		}
		return false;
	}

}
