/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.theme.jetspeed;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.skin.PortletEditOption;
import com.ponpo.portal.util.Environment;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionDataImpl;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class JetSpeedThemeOption implements PortletEditOption{

	/*
	 *  ( Javadoc)
	 * @see com.ponpo.portal.service.EditOption#getOptions(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public OptionData[] getOptions(HttpServletRequest req, String key) throws PortalException{
		File jetSpeedPath=Environment.getRealPath("theme/jetSpeed");
		String themes[]=jetSpeedPath.list();
		Collection col=new ArrayList();
		for (int cnt = 0; cnt < themes.length; cnt++) {
			String name=themes[cnt];
			if(name.lastIndexOf(".jsp")!=-1){
				name=name.substring(0,name.length()-4);
				if(!name.equals("color")){
					col.add(new OptionDataImpl(name,name));
				}
			}
			
		}
		return (OptionDataImpl[])col.toArray(new OptionDataImpl[0]);

	}

}
