/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeSet;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class FileUtils {
	/**
	 * fBNĝׂẴt@C폜B
	 * @param	file	폜fBNg
	 */
	public final static void treeDel(File file) throws IOException {
		if(file.isDirectory()){
			File[] fileList= file.listFiles();
			if(fileList!=null){
				for (int cnt = 0; cnt < fileList.length; cnt++) {
					treeDel(fileList[cnt]);
				}
			}
		}
		if(file.exists()){
			if(!file.delete()){
				throw new IOException("Can't not delete file:"+file);
			}
		}
	}
	public final static void rename(File fromFile,File toFile) throws IOException {
		if(toFile.exists()){
			treeDel(toFile);
		}

		if(!fromFile.renameTo(toFile)){
			throw new IOException("Can't not rename file:"+fromFile +"->"+toFile);
		}
	}
	public final static Collection findFiles(File targetDir,int cutIndex) throws IOException{
		Collection col =new TreeSet();
		File[] targetFiles=targetDir.listFiles();
		if(targetFiles!=null){
			for (int cnt = 0; cnt < targetFiles.length; cnt++) {
				if(targetFiles[cnt].isDirectory()){
					col.addAll(findFiles(targetFiles[cnt],cutIndex));
				}else{
					String fName=targetFiles[cnt].getPath().substring(cutIndex);
					if(File.separatorChar=='\\')fName=fName.replaceAll("\\\\","/");
					col.add(fName);
				}
			}
		}
		return col;
	}
	public final static void treeCopy(File fromDir,File toDir) throws IOException{
		if(!toDir.exists()){
			if(!toDir.mkdirs()){
				throw new IOException("not make dirctory:"+toDir);
			}
		}
		File[] formFiles=fromDir.listFiles();
		if(formFiles!=null){
			for (int cnt = 0; cnt < formFiles.length; cnt++) {
				File toFile=new File(toDir,formFiles[cnt].getName());
				if(formFiles[cnt].isDirectory()){
				
					treeCopy(formFiles[cnt],toFile);
				}else{
					FileUtils.rename(formFiles[cnt],toFile);
				}
			}
		}
	}

}
