/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class JspLoader {
	private static Log log= LogFactory.getLog(JspLoader.class);
	public String doView(HttpServletRequest req, HttpServletResponse res, String jspFileName)
		throws ServletException, IOException {

		if (jspFileName != null) {
			RequestDispatcher dispatch= req.getRequestDispatcher(jspFileName);
			if (log.isDebugEnabled()) {
				log.debug("disptch:" + jspFileName);
			}

			ActionResponseWrapper myRes= new ActionResponseWrapper(res);

			dispatch.forward(req, myRes);

			return myRes.toString();
		}
		return "";
	}

	class ActionResponseWrapper extends HttpServletResponseWrapper {

		private PrintWriter _PrintWriter;
		private StringWriter _StringWriter;
		private String _Redirect_Location= null;

		public ActionResponseWrapper(ServletResponse response) {

			super((HttpServletResponse)response);
			_StringWriter= new StringWriter();
			_PrintWriter= new PrintWriter(_StringWriter);
		}

		/* ( Javadoc)
		 * @see javax.servlet.ServletResponse#getWriter()
		 */
		public PrintWriter getWriter() throws IOException {
			return _PrintWriter;
		}
		/* ( Javadoc)
		 * @see javax.servlet.http.HttpServletResponse#sendRedirect(java.lang.String)
		 */
		public void sendRedirect(String location) throws IOException {
			_Redirect_Location= location;
		}
		public String getRedirect() throws IOException {
			return _Redirect_Location;
		}

		/* ( Javadoc)
		 * @see java.lang.Object#toString()
		 */
		public String toString() {
			if (_ServlerError != HttpServletResponse.SC_OK) {
				StringBuffer sb= new StringBuffer();
				sb.append("<pre>");
				sb.append("JSPŃG[\n");
				sb.append("G[mF" + getSendError());
				sb.append("\nbZ[WF" + getSendErrorMsg());
				sb.append("</pre>");
				return sb.toString();
			}

			return _StringWriter.toString();
		}

		private int _ServlerError= HttpServletResponse.SC_OK;
		private String _ServlerErrorMsg= "";
		/* ( Javadoc)
		 * @see javax.servlet.http.HttpServletResponse#sendError(int, java.lang.String)
		 */
		public void sendError(int arg0, String arg1) throws IOException {
			_ServlerError= arg0;
			_ServlerErrorMsg= arg1;
		}

		/* ( Javadoc)
		 * @see javax.servlet.http.HttpServletResponse#sendError(int)
		 */
		public void sendError(int arg0) throws IOException {
			sendError(arg0, "");
		}
		public int getSendError() {
			return _ServlerError;
		}
		public String getSendErrorMsg() {
			return _ServlerErrorMsg;
		}

		/* ( Javadoc)
		 * @see javax.servlet.ServletResponse#isCommitted()
		 */
		public boolean isCommitted() {
			return false;
		}

	}
}
