/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.util;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;



/**
 * NGXg[eBB<BR>
 * <PRE>
 * NGXgɊւẴ[eBłB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class RequestUtils {
	private static String ACCESS_KEY = RequestUtils.class.getName() + ".KEY";
	/**
	 * ANV擾B<BR>
	 * <PRE>
	 * ANV擾܂
	 * </PRE>
	 * @param req@NGXg
	 * @return@ANV
	 */
	public static String getActionName(HttpServletRequest req) {
		RequestControl control = getCotrol(req);

		return control.getActionName();
	}
	/**
	 * ANVB<BR>
	 * <PRE>
	 * w肵ANV邩܂B
	 * </PRE>
	 * @param req@NGXg
	 * @param value@ANV
	 * @return@trueFNGXg̒ɃANV
	 */
	public static boolean isActName(HttpServletRequest req, String value) {
		RequestControl control = getCotrol(req);
		if(control==null){
			return false;
		}
		return value.equals(control.getActionName());
	}
	/**
	 * FormANVB<BR>
	 * <PRE>
	 * Form̃ANV܂B
	 * </PRE>
	 * @param req@NGXg
	 * @return@true:tH[̃ANV
	 */
	public static boolean isExecuteAction(HttpServletRequest req) {
		RequestControl control = getCotrol(req);

		return control.isExecuteAction();
	}
	/**
	 * CAEg擾B<BR>
	 * <PRE>
	 * NGXĝȂ̃CAEg擾܂B
	 * </PRE>
	 * @param req@NGXg
	 * @return@CAEg
	 */
	private static RequestControl getCotrol(HttpServletRequest req) {
		if(req==null){
			return null;
		}
		RequestControl control = (RequestControl) req.getAttribute(ACCESS_KEY);
		if (control == null) {
			control = new RequestControl(req);
			req.setAttribute(ACCESS_KEY, control);
		}
		return control;

	}
	/**
	 * JgtqkpX擾B<BR>
	 * <PRE>
	 * JgtqkpX擾擾܂
	 * </PRE>
	 * @param req@NGXg
	 * @return@JgtqkpX
	 */
	public static String getCurrentUrlPath(HttpServletRequest req) {
		String rtn;
		rtn = req.getContextPath() + req.getServletPath() + req.getPathInfo();
		return rtn;
	}
	static private String MULTI = RequestUtils.class +".MULTI";
	/**
	 * }`p[g擾B<BR>
	 * <PRE>
	 * }`p[g擾܂B<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @return@}`p[gXg
	 */
	static public List getMultiRequest(HttpServletRequest req) {
		return (List) req.getAttribute(MULTI);
	}
	/**
	 * }`p[gݒB<BR>
	 * <PRE>
	 *}`p[gݒ肵܂B<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param list@}`p[gXg
	 */
	static public void setMultiRequest(HttpServletRequest req, List list) {
		req.setAttribute(MULTI, list);
	}

}
class RequestControl{
	private String _ActionName;
	private boolean _ExecuteAction = false;
	
	public RequestControl(HttpServletRequest req) {
	
		if(FileUpload.isMultipartContent(req)){
			doMultipartRequest(req);
		}else{
			doNormalRequest(req);
		}
	}
		
	private void doMultipartRequest(HttpServletRequest req) {
		List items=RequestUtils.getMultiRequest(req);
		for (Iterator iter = items.iterator(); iter.hasNext();) {
			FileItem fileItem = (FileItem) iter.next();
	
			String key = (String) fileItem.getFieldName();
			if (key.startsWith("exec.")) {
				_ActionName = key.substring(5);
				_ExecuteAction = true;
				break;
			} else if (key.startsWith("ACT")) {
				_ActionName = req.getParameter(key);
				_ExecuteAction = false;
			}
		}
	}
	private void doNormalRequest(HttpServletRequest req){
		Enumeration enum = req.getParameterNames();
	
		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement();
			if (key.startsWith("exec.")) {
				_ActionName = key.substring(5);
				_ExecuteAction = true;
				break;
			} else if (key.startsWith("ACT")) {
				_ActionName = req.getParameter(key);
				_ExecuteAction = false;
			}
		}
	}
	
	public String getActionName() {
		return _ActionName;
	}
	
	public boolean isExecuteAction() {
		return _ExecuteAction;
	}

}