/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.util;

import java.text.DecimalFormat;

/**
 * 񃆁[eBe[B<BR>
 * <UL>
 * rɊւ[eBeB
 * </UL>
 * @since 1.0.0
 * @version 1.00.00
 * @author Y.Sasaki
 */
public class StringUtils {
	private StringUtils(){
	}
	/**
	 * ̋󔒍폜B<BR>
	 * <UL>
	 *   ɑ݂󔒁iSp󔒁Ap󔒁j폜ԂB<BR>
	 * </UL>
	 * <BR>
	 * @param	strText	󔒍폜Ώە
	 * @return 󔒂폜
	 */
	public static final String delBlank(String strText) {

		StringBuffer strDelBlank = new StringBuffer("");

		for (int i = 0; i < strText.length(); i++) {
			if (!Character.isSpaceChar(strText.charAt(i))) {
				strDelBlank.append(strText.charAt(i));
			}
		}

		return strDelBlank.toString();
	}

	/**
	 * woCg擾B<BR>
	 * <UL>
	 *   woCg̕Ԃ܂B<BR>
	 * </UL>
	 * <BR>
	 * @param	strText	
	 * @param	intBytesLength		擾oCg
	 * @return 擾
	 */
	public static final String getBytesLength(String strText, int intBytesLength) {

		int i = 0;
		int len = 0;
		String strEdit = "";

		/* 擾oCgԂ */
		// ̃oCg擾oCg傫ꍇ
		if (strText.getBytes().length > intBytesLength) {
			while (len < intBytesLength) {
				len = len + strText.substring(i, i + 1).getBytes().length;
				if (len <= intBytesLength) {
					strEdit = strEdit + strText.substring(i, i + 1);
				}
				i++;
			}
			// ̃oCg擾oCgȉ̏ꍇ
		} else {
			strEdit = strText;
		}

		return strEdit;
	}

	/**
	 * 蕶̎擾B<BR>
	 * <UL>
	 *   ꕶ񂾕擾B<BR>
	 * </UL>
	 * <BR>
	 * @param str ׂ镶
	 * @param number o͂
	 * @return strnumber񂾕
	 */
	public static String getChars(String str, int number) {
		StringBuffer chars = new StringBuffer("");
		for (int i = 0; i < number; i++) {
			chars.append(str);
		}
		return chars.toString();
	}

	/**
	 * 蕶߂̎擾B<BR>
	 * <UL>
	 *   蕶߂擾B<BR>
	 * </UL>
	 * <BR>
	 * @param intText ̓eLXg
	 * @param strFormat tH[}bgp^[
	 * @return 蕶߂ꂽ
	 */
	public static String getIntFormat(int intText, String strFormat) {
		try {
			DecimalFormat decFormat = new DecimalFormat();
			decFormat.applyPattern(strFormat);
			return decFormat.format(intText);
		} catch (NumberFormatException e) {
			return "";
		}
	}
	/**
	 * ϊB<BR>
	 * <UL>
	 *   w肳ꂽ̒ϊO񂩂ϊ㕶ɕϊ܂B<BR>
	 * </UL>
	 * @param buff ϊ镶<BR>
	 * @param befor_str ϊO<BR>
	 * @param after_str ϊ㕶<BR>
	 * @return ϊꂽ<BR>
	 */
	public static String cnvStr(String buff, String befor_str, String after_str) {
		if(buff==null){
			return null;
		}
		int pos;
		if ((pos = buff.indexOf(befor_str)) >= 0) {
			if ((pos + befor_str.length()) == buff.length()) {
				return buff.substring(0, pos) + after_str;
			} else if (pos == 0) {
				return after_str
					+ cnvStr(
						buff.substring(pos + befor_str.length()),
						befor_str,
						after_str);
			} else {
				return buff.substring(0, pos)
					+ after_str
					+ cnvStr(
						buff.substring(pos + befor_str.length()),
						befor_str,
						after_str);
			}
		}
		return (buff);
	}
	/**
	 * HTMLo͕ϊB<BR>
	 * <UL>
	 *   w肳ꂽɓꕶLϊ܂B<BR>
	 *   <LI>G</LI>
	 *   <LI>hG</LI>
	 *   <LI>G</LI>
	 *   <LI>G</LI>
	 *   <LI> i󔒁j;</LI>
	 * </UL>
	 * @param buff ϊ镶<BR>
	 * @return ϊꂽ<BR>
	 */
	public static String cnvHtmlStr(String buff) {
		String str;
		str=cnvStr(buff,"&","&amp;");
		str=cnvStr(str,"\"","&quot;");
		str=cnvStr(str,">","&gt;");
		str=cnvStr(str,"<","&lt;");
//		str=cnvStr(str," ","&ensp;");
		return str;
	}
	public static String cnvValue4Len0(String value) {
		String rtn;
		if(value==null){
			rtn = null;
			return rtn;
		}
		rtn = value.trim();
		if (rtn.length() == 0) {
			rtn = null;
		}
		return rtn;
	}
	public static boolean isEmpty(String value) {
		if(value==null){
			return true;
		}
		String rtn= value.trim();
		if (rtn.length() == 0) {
			return true;
		}
		return false;
	}
	/**
	 * pXB<BR>
	 * <PRE>
	 * pX̕s܂B
	 * ex.
	 * /aaaa/bbb/cccc
	 * [0]:aaaa
	 * [1]:/bbb/cccc
	 * </PRE>
	 * @param path@pX
	 * @return@[0]FepX@[1]qpX
	 */
	public static String[] separatPath(String path){
		String separatPath[]=new String[2];
		if(path==null||path.length()<1){
			separatPath[0]="";
			separatPath[1]="";
		}else{
			String tagString=path.substring(1);
			int pos=tagString.indexOf("/");
			if(pos!=-1){
				separatPath[0]=tagString.substring(0,pos);
				separatPath[1]=tagString.substring(pos);

			}else{
				separatPath[0]=tagString;
				separatPath[1]="";
			}
		}
		return separatPath;
	}
	public static String[] cnvComma2Array(String value){
		if(value==null){
			return new String[0];
		}
		return value.split(",");
	}

}