/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * ̓`FbNB<BR>
 * <PRE>
 * ͂`FbNNXB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class Validator {
	/**
	 * p`FbNB<BR>
	 * <PRE>
	 * p`FbNB
	 * </PRE>
	 * @param value `FbN镶
	 * @return `FbN
	 */
	static public boolean checkNotAlphanumeric(String value){
		if(value==null){
			return false;
		}
		return checkFomat(value,"[^a-zA-Z0-9]" );
	}
	/**
	 * p`FbNB<BR>
	 * <PRE>
	 * p`FbNB
	 * </PRE>
	 * @param value `FbN镶
	 * @return `FbN
	 */
	static public boolean checkNotAlphanumericPlus(String value,String ext){
		if(value==null){
			return false;
		}
		return checkFomat(value,"[^a-zA-Z0-9"+ext+"]" );
	}
	/**
	 * `FbNB<BR>
	 * <PRE>
	 * `FbNB
	 * </PRE>
	 * @param value `FbN镶
	 * @return `FbN
	 */
	static public boolean checkNotDigit(String value){
		if(value==null){
			return false;
		}
		return checkFomat(value,"[^0-9_]" );
	}
	/**
	 * K\`FbNB<BR>
	 * <PRE>
	 * K\`FbN܂B<BR>
	 * </PRE>
	 * @param input@`FbN镶
	 * @param fmt@tH[}bg
	 * @return@true:w肳ꂽK\ł
	 */
	static public boolean checkFomat(String input, String fmt) {
		Pattern pattern = Pattern.compile(fmt, Pattern.CASE_INSENSITIVE);
		Matcher matcher = pattern.matcher(input);
		return matcher.find();
	}
	/**
	 * 󕶎`FbNB<BR>
	 * <PRE>
	 * 󕶎`FbN܂B<BR>
	 * </PRE>
	 * @param input@`FbN镶
	 * @return@true:󕶎ł@
	 */
	static public boolean checkEmpty(String input) {
		boolean rtn = true;
		if (input != null && input.length() > 0) {
			rtn = false;
		}
		return rtn;
	}
	/**
	 * 񒷃`FbNB<BR>
	 * <PRE>
	 * w肳ꂽw肳ꂽł邩`FbN܂B<BR>
	 * </PRE>
	 * @param input@`FbN镶
	 * @param len@
	 * @return@truew肳ꂽ̒łB
	 */
	static public boolean checkLenEqual(String input, int len) {
		boolean rtn = false;
		if (input != null && input.length() == len) {
			rtn = true;
		}
		return rtn;
	}
	/**
	 * 񒷃`FbNB<BR>
	 * <PRE>
	 * w肳ꂽw肳ꂽȉł邩`FbN܂B<BR>
	 * </PRE>
	 * @param input@`FbN镶
	 * @param len@
	 * @return@true@w肳ꂽ̒ȉłB
	 */
	static public boolean checkLenLessEqual(String input, int len) {
		boolean rtn = false;
		if (input != null && input.length() <= len) {
			rtn = true;
		}
		return rtn;
	}
	/**
	 * ttH[}bg`FbNB<BR>
	 * <PRE>
	 * w肳ꂽ񂪓ttH[}bĝł邩`FbNB<BR>
	 * </PRE>
	 * @param input@`FbN镶
	 * @param pattern@tH[}bg
	 * @return@w肳ꂽtH[}bgł
	 */
	static public boolean checkDateFormat(String input, String pattern) {
		SimpleDateFormat format = new SimpleDateFormat(pattern);
		try {
			format.parse(input);
		} catch (ParseException e) {
			return false;
		}

		return true;
	}

}
