/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib;

/**
 * tB^[B<BR>
 * <PRE>
 * gslkpɊe핶ϊ܂B<BR>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class Filter {
	/**
	 * f[^tB^OB<BR>
	 * <PRE>
	 * f[^tB^O܂B<BR>
	 * </PRE>
	 * @param obj@l
	 * @return@tB^O
	 */
	public static String doFilter(Object obj) {
		if (obj == null) {
			return "";
		}
		return doFilter(obj.toString());
	}
	/**
	 * f[^tB^OB<BR>
	 * <PRE>
	 * f[^tB^O܂B<BR>
	 * </PRE>
	 * @param message@l
	 * @return@tB^O
	 */
	public static String doFilter(String message) {

		if (message == null) {
			return "";
		}

		char content[] = new char[message.length()];
		message.getChars(0, message.length(), content, 0);
		StringBuffer result = new StringBuffer(content.length + 50);
		for (int cnt = 0; cnt < content.length; cnt++) {
			switch (content[cnt]) {
				case '<' :
					result.append("&lt;");
					break;
				case '>' :
					result.append("&gt;");
					break;
				case '&' :
					result.append("&amp;");
					break;
				case '"' :
					result.append("&quot;");
					break;
				case ' ' ://IEł&nbsp;ԂƂ΂
//				result.append("&nbsp;");
				result.append(" ");
					break;
				case 0xa0 :
//					result.append("&nbsp;");
					break;

				default :
					result.append(content[cnt]);
			}
		}
		return (result.toString());
	}

}
