/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib;

import java.util.HashMap;
import java.util.Map;

import com.ponpo.parse.xml.BaseDigester;
import com.ponpo.parse.xml.XMLParseBase;




/**
 * appResourceXMĹB<BR>
 * <UL>
 * appResourceXML̉͂s܂B<BR>
 * </UL>
 * @since 1.0.0
 * @version 1.00.00
 * @author Yoshi Sasaki
 */
public class ParseAppResource extends XMLParseBase{

	private Map _DataMap=new HashMap();
	public void add(Object data){
		AppResourceData resourceData=(AppResourceData)data;
		_DataMap.put(resourceData.getName(),resourceData.getValue()  );
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.parse.ParseBase#setDetailRule(com.ponpo.portal.parse.BaseDigester)
	 */
	protected void setDetailRule(BaseDigester digester) {
		digester.addObjectCreate("appResource/label", "com.ponpo.taglib.AppResourceData");
		digester.addSetProperties("appResource/label");
		digester.addCallMethod("appResource/label/value", "setValue", 0);
		digester.addSetNext("appResource/label", "add");
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.parse.ParseBase#getReturnData()
	 */
	protected Object getReturnData() {
		return _DataMap;
	}
}
