/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

import org.xml.sax.SAXException;

import com.ponpo.portal.util.Environment;


/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class ResourceManeger {
	public static String KEY_MAP=ResourceManeger.class.getName()+"KEY_MAP";

	private static  Map _ResorceDatas;
	public  static String getResorceValue(PageContext context,String key) throws JspException{
		return getResorceValue(context.getServletContext(),context.getRequest(),key);
	}
	private  static String getResorceValue(ServletContext context,ServletRequest req,String key) throws JspException{
		String locale=null;
		if(_ResorceDatas==null){
		   loadConfig(context);
		}
		for (Enumeration enum = req.getLocales() ; enum.hasMoreElements() ;) {
			Locale reqLocal=(Locale)enum.nextElement();
			if(_ResorceDatas.containsKey(reqLocal.getLanguage()  )){
				locale=reqLocal.getLanguage();
				break;
			}
		 }
		Map mapData=null;
		if(locale!=null){
			mapData= (Map)_ResorceDatas.get(locale);
		}
		if(mapData==null){
			mapData= (Map)_ResorceDatas.get(null);
		}
		return (String)mapData.get(key);
	}
	private  static void loadConfig(ServletContext context) throws JspException {
		try {


			String configFname;
			FileInputStream pw;

			String configBase = "WEB-INF/config/";
			File configDir = new File(context.getRealPath(configBase));

			String files[] = configDir.list();
			for (int cnt = 0; cnt < files.length; cnt++) {

				configFname = configDir.toString() + "/" + files[cnt];

				if (files[cnt].indexOf("appResource") == 0) {

					pw = new FileInputStream(configFname);
					ParseAppResource parse = new ParseAppResource();
					if(_ResorceDatas==null){
						_ResorceDatas=new HashMap();
					}
					_ResorceDatas.put(
						getRecourceCountry(files[cnt]),
						parse.loadXMLData(pw, Environment.getRealPath("/")));
					pw.close();
				}
			}

		} catch (IOException e) {
			throw new JspException(e);
		} catch (SAXException e) {
			throw new JspException(e);
		}
	}
	private  static String getRecourceCountry(String fname) {
		if (fname.indexOf("appResource_") >= 0) {
			return fname.substring(12, 14);
		} else {
			return null;
		}
	}

}
