/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.html;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

import com.ponpo.taglib.DataManager;
import com.ponpo.taglib.Filter;
import com.ponpo.taglib.PlainData;
import com.ponpo.taglib.ResourceManeger;

/**
 * l\^OB<BR>
 * <PRE>
 * l\邽߂̃^OłB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class DspTag extends TagSupportBase {

	private boolean _LookUp = false;
	private boolean _Filter = true;
	public void setLookUp(String value) {
		_LookUp = value.equals("true");
	}
	public void setFilter(String value) {
		_Filter = value.equals("true");;
	}


	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		try {
			HttpServletRequest req=(HttpServletRequest)pageContext.getRequest();
			PlainData data =
				(PlainData) DataManager.getData(req);
			if (data == null) {
				;
			} else {

				String value = (String) data.getTagData(req,getId());
				if (_LookUp) {
					value=ResourceManeger.getResorceValue(pageContext,value);
				}
				if(value!=null){
					if(_Filter){
						pageContext.getOut().print(Filter.doFilter(value));
					}else{
						pageContext.getOut().print(value);
					}
				}
			}
		} catch (IOException e) {
			throw new JspException(e);
		}
		return SKIP_BODY;
	}


}