/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.html;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import com.ponpo.taglib.DataManager;


/**
 * tH[^OB<BR>
 * <PRE>
 * tH[^O\܂B
 * vOł͂ǂɑ΂Form/ACtions΂悢킩Ȃ
 * ̃^O܂B
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class FormTag extends BodyTagSupport {
	private String _Enctype;
	private String _Name;
	public void setEnctype(String string) {
		_Enctype = string;
	}
	public void setName(String string) {
		_Name = string;
	}
	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		
		try {
			
			String enctype;
			if(_Enctype==null){
				enctype="";
			}else{
				enctype=" enctype=\""+_Enctype + "\"";
			}
			String name;
			if(_Name==null){
				name="";
			}else{
				name=" name=\""+_Name+ "\"";
			}
			
			String url=DataManager.getRequestURL(pageContext.getRequest());
			if(url==null){
				url="";
			}else{
				url=" action=\""+url+"\"";
			}
			pageContext.getOut().println("<form method=\"POST\""+ url + name + enctype+ ">");
			
		} catch (IOException e) {
			throw new JspException(e);
		}

		return EVAL_BODY_INCLUDE;
	}
	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException {
		try {
			pageContext.getOut().println("</form>");
		} catch (IOException e) {
			throw new JspException(e);
		}
		return SKIP_BODY;
	}


}
