/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.html;

import java.io.IOException;

import javax.servlet.jsp.JspException;

import com.ponpo.taglib.ResourceManeger;

/**
 * bZ[W^OB<BR>
 * <PRE>
 * bZ[W\[X\邽߂̃^OłB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class MsgTag extends TagSupportBase {
	private String _Span = null;
	public void setSpan(String string) {
		_Span = string;
	}

	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		try {
			if (_Span != null) {
				pageContext.getOut().print("<span class=\"" + _Span + "\">");
			}
			pageContext.getOut().print(ResourceManeger.getResorceValue(pageContext,getId()));
			if (_Span != null) {
				pageContext.getOut().print("</span>");
			}
		} catch (IOException e) {
			throw new JspException(e);
		}
		return SKIP_BODY;
	}


}