/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.html;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

import com.ponpo.taglib.DataManager;
import com.ponpo.taglib.Filter;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.SelectData;

/**
 * ZNg^OB<BR>
 * <PRE>
 * ZNg^O邽߂̃^OłB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class SelectTag extends TagSupportBase {

	private String _Size;


	public void setSize(String string) {
		_Size = string;
	}

	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {

		try {
			HttpServletRequest req=(HttpServletRequest)pageContext.getRequest();

			SelectData selectData =
				(SelectData) DataManager.getData(req);
			String value = selectData.getSelectValue(req,getId());
			OptionData optionDatas[] = selectData.getOptions(req,getId());

			StringBuffer out = new StringBuffer();

			out.append("<select");
			if (_Size != null) {
				out.append(" size=\"");
				out.append(_Size);
				out.append("\"");
			} else {
			}
			out.append(" name=\"");
			out.append(getId());
			out.append("\">\n");
			if (optionDatas != null) {
				for (int cnt = 0; cnt < optionDatas.length; cnt++) {
					OptionData option = optionDatas[cnt];
					out.append("<option ");
					if (value != null && value.equals(option.getValue())) {
						out.append("selected ");
					}
					out.append("value=\"");
					out.append(Filter.doFilter(option.getValue()));
					out.append("\">");
					out.append(Filter.doFilter(option.getLavel()));
					out.append("</option>\n");
				}
			}
			out.append("</select>");
			pageContext.getOut().print(out.toString());

		} catch (Exception ex) {
			throw new JspException(ex);
		}
		return EVAL_BODY_INCLUDE;
	}

}
