/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.html;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import com.ponpo.portal.util.RequestUtils;
import com.ponpo.taglib.Filter;
import com.ponpo.taglib.ResourceManeger;

/**
 * Tu~bg^OB<BR>
 * <PRE>
 * Tu~bgp̃^OłB
 * ̃^OɂANV܂B
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class SubmitTag extends TagSupport {
	private String _Default;
	public void setDefault(String string) {
		_Default = string;
	}
	private boolean _lookUp = true;


	public void setLookUp(String value) {
		_lookUp = value.equals("true");
	}

	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();

		try {

			pageContext.getOut().println(
				"<input type=\"submit\" name=\"exec."
					+ getAction(req)
					+ "\" value=\""
					+ Filter.doFilter(selectSubmitName(req))
					+ "\">");
		} catch (IOException e) {
			throw new JspException(e);
		}
		return SKIP_BODY;
	}
	private String selectSubmitName(HttpServletRequest req) throws JspException {
		String searchWord = "cmn.label.submit." + getAction(req);
		return ResourceManeger.getResorceValue(pageContext,searchWord);
	}

	private String getAction(HttpServletRequest req) {

		String rtn;
		if (_lookUp) {
			rtn = RequestUtils.getActionName(req);
			if (rtn == null) {
				rtn = _Default;
			}
		} else {
			rtn = _Default;
		}
		return rtn;

	}
}
