/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.html;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

import com.ponpo.taglib.DataManager;
import com.ponpo.taglib.PlainData;


/**
 * TagLibB<BR>
 * <PRE>
 * ̃pbP[W̃^O̊łB<BR>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class TagSupportBase extends javax.servlet.jsp.tagext.TagSupport {
	protected TagAttribute _Attributes = new TagAttribute();
	
	protected String getValue() throws JspException{
		HttpServletRequest req=(HttpServletRequest)pageContext.getRequest();

		String rtn=null;
		PlainData data =
			(PlainData) DataManager.getData(req);
		if (data != null) {
			rtn = data.getTagData(req,getId());
		}
		return rtn;
	}

	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#release()
	 */
	public void release() {
		_Attributes = new TagAttribute();
	}

}
