/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.html;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

import com.ponpo.taglib.DataManager;
import com.ponpo.taglib.Filter;
import com.ponpo.taglib.PlainData;

public class TextAreaTag extends TagSupportBase {

	public void setCols(String string) {
		_Attributes.put("cols", string);
	}

	public void setRows(String string) {
		_Attributes.put("rows", string);
	}

	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		try {
			StringBuffer sb = new StringBuffer();
			_Attributes.putAtFirst("name", getId());
			sb.append("<textarea ");
			sb.append(_Attributes.getAttributes());
			sb.append(">");
			
			HttpServletRequest req=(HttpServletRequest)pageContext.getRequest();
			PlainData data =
				(PlainData) DataManager.getData(req);
			if (data != null) {
				String value = (String) data.getTagData(req,getId());
				sb.append(Filter.doFilter(value));
			}
			sb.append("</textarea>");
			pageContext.getOut().print(sb.toString());
		} catch (IOException e) {
			throw new JspException(e);
		}
		return SKIP_BODY;
	}


}