/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.logic;

import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * JԂvfΉ^OB<BR>
 * <PRE>
 * JԂs̗vf邽߂̃^OłB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class IterateEqualTag extends TagSupport {
	private String _Name;
	private String _Value;
	public void setName(String string) {
		_Name = string;
	}
	public void setValue(String string) {
		_Value = string;
	}

	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		Map inputMap = (Map) this.pageContext.getAttribute(getId());
		if (inputMap == null) {
			return SKIP_BODY;
		}
		
		String value = (String) inputMap.get(_Name);
		if(value==null){
			value="";
		}
		if (_Value.equals(value)) {
			return EVAL_BODY_INCLUDE;
		} else {
			return SKIP_BODY;
		}
			
	}
	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.IterationTag#doAfterBody()
	 */
	public int doAfterBody() throws JspException {
		return SKIP_BODY;
	}


}
