/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.logic;

import java.io.IOException;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import com.ponpo.taglib.Filter;

/**
 * JԂvfΉ^OB<BR>
 * <PRE>
 * JԂs̗vf邽߂̃^OłB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class IterateItemTag extends TagSupport {
	private String _Name;
	public void setName(String string) {
		_Name = string;
	}
	private boolean _Filter = true;
	public void setFilter(String value) {
		_Filter = value.equals("true");;
	}

	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		if(_Name==null){
		}
		Object value =  this.pageContext.getAttribute(getId());
		if(value ==null){
			return SKIP_BODY;
		}else if (value instanceof Map) {
			Map inputMap = (Map) value;
			value=inputMap.get(_Name);
		}
		
		try {
			if(value!=null){
				if(_Filter){
					pageContext.getOut().print(Filter.doFilter(Filter.doFilter(value.toString())));
				}else{
					pageContext.getOut().print(value.toString());
				}
			}
		} catch (IOException e) {
			throw new JspException(e);
		}
		return SKIP_BODY;
	}


}
