/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.taglib.logic;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.beanutils.BeanUtils;

import com.ponpo.taglib.DataManager;
import com.ponpo.taglib.IterateData;

/**
 * JԂ^OB<BR>
 * <PRE>
 * JԂs̃^OłB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class IterateTag extends TagSupport {
	private Iterator _Iterator;

	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		try {
			if (_Iterator == null) {
				HttpServletRequest req=(HttpServletRequest)pageContext.getRequest();

				IterateData iterateData =
					(IterateData) DataManager.getData(req);
				if (iterateData != null) {
					Object obj= iterateData.getIterator(req,getId());
					if (obj ==null) {
						_Iterator=null;
					}else	if (obj instanceof Iterator) {
						_Iterator=(Iterator)obj;
					}else	if (obj instanceof Collection) {
						_Iterator=((Collection)obj).iterator();
					}else if (obj instanceof Map) {
						_Iterator=((Map)obj).entrySet().iterator();
					}else{
						throw new JspException(new Exception("ProgramError :unSerported Class:"+obj.getClass().getName()));
					}
				}
			}
			return doAfterBody();
		} catch (JspException ex) {
			throw ex;
		} catch (Exception ex) {
			throw new JspException(ex);
		}
	}

	/* ( Javadoc)
	 * @see javax.servlet.jsp.tagext.IterationTag#doAfterBody()
	 */
	public int doAfterBody() throws JspException {
		if (_Iterator == null) {
			return SKIP_BODY;
		}
		if (!_Iterator.hasNext()) {
			_Iterator = null;
			return SKIP_BODY;
		} else {
			Object data = _Iterator.next();
			if (data instanceof Map) {
				;
			}else	if (data instanceof String) {
				;
			} else {
				try {
					data = BeanUtils.describe(data);
				} catch (Exception ex) {
					throw new JspException(ex);
				}
			}
			this.pageContext.setAttribute(getId(), data);
			return EVAL_BODY_AGAIN;
		}
	}

}
