/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jp.thisnor.dre.core.MeasureOptionEntry;
import jp.thisnor.dre.core.MeasurerPackage;
import jp.thisnor.dre.core.PathFilter;
import jp.thisnor.dre.core.ProgressListener;
import jp.thisnor.dre.core.SimilarEntry;
import jp.thisnor.dre.core.SimilarGroup;
import jp.thisnor.dre.core.WholeTask;

class ConsoleApp {
    private String packageName;
    private List<String> targetPathList;
    private List<String> storagePathList;
    private PathFilter filter;
    private Map<String, String> optionStrMap;
    private int numThreads = 1;
    private static final ProgressListener STDERR_PROGRESS_LISTENER = new ProgressListener(){

        @Override
        public void progressLoad(int step, int size) {
        }

        @Override
        public void progressMeasure(int step, int size) {
        }

        @Override
        public void log(String line) {
            System.err.println(line);
        }
    };

    ConsoleApp(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("--package=")) {
                this.packageName = arg.substring("--package=".length());
            } else if (arg.startsWith("--storage-path=")) {
                this.storagePathList = ConsoleApp.textToList(arg.substring("--storage-path=".length()));
            } else if (arg.startsWith("--filter=")) {
                this.filter = ConsoleApp.textToFilter(arg.substring("--filter=".length()));
            } else if (arg.startsWith("--package-option=")) {
                this.optionStrMap = ConsoleApp.textToMap(arg.substring("--package-option=".length()));
            } else if (arg.startsWith("--num-threads=")) {
                try {
                    this.numThreads = Integer.parseInt(arg.substring("--numthreads=".length()));
                }
                catch (NumberFormatException e) {
                    System.err.println("WARNING: Need number: " + arg);
                    this.numThreads = 1;
                }
            } else {
                this.targetPathList = ConsoleApp.textToList(arg);
            }
            ++n2;
        }
    }

    private static List<String> textToList(String text) {
        String[] strs = text.split(":");
        List<String> strList = Collections.synchronizedList(new ArrayList(strs.length));
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.charAt(0) == '\"') {
                str = str.substring(1);
            }
            if (str.charAt(str.length() - 1) == '\"') {
                str = str.substring(0, str.length() - 1);
            }
            strList.add(str);
            ++n2;
        }
        return strList;
    }

    private static Map<String, String> textToMap(String text) {
        String[] strs = text.split(":");
        HashMap<String, String> strMap = new HashMap<String, String>(strs.length, 2.0f);
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String str = stringArray[n2];
            int seppos = str.indexOf(61);
            String key = seppos >= 0 ? str.substring(0, seppos) : str;
            String string = value = seppos >= 0 ? str.substring(seppos + 1) : "true";
            if (value.charAt(0) == '\"') {
                value = value.substring(1);
            }
            if (value.charAt(value.length() - 1) == '\"') {
                value = value.substring(0, value.length() - 1);
            }
            strMap.put(key, value);
            ++n2;
        }
        return strMap;
    }

    private static PathFilter textToFilter(String text) {
        if (text.charAt(0) == '\"') {
            text = text.substring(1);
        }
        if (text.charAt(text.length() - 1) == '\"') {
            text = text.substring(0, text.length() - 1);
        }
        final Pattern pattern = Pattern.compile(text);
        return new PathFilter(){

            @Override
            public boolean accept(String path) {
                return pattern.matcher(path).matches();
            }
        };
    }

    boolean run() {
        if (this.packageName == null) {
            System.err.println("ERROR: Specify package with --package=*");
        }
        System.err.println("Loading the package...");
        MeasurerPackage measurerPackage = null;
        try {
            measurerPackage = MeasurerPackage.importPackage(this.packageName);
        }
        catch (IOException e) {
            System.err.println("ERROR: Not found specified package: " + this.packageName);
            return false;
        }
        System.err.println("  package key: " + measurerPackage.getKey());
        System.err.println("  package name: " + measurerPackage.getName());
        System.err.println("  version: " + measurerPackage.getVersion());
        Map<String, MeasureOptionEntry> optionMap = measurerPackage.getOptionMap();
        if (this.optionStrMap != null) {
            for (Map.Entry entry : this.optionStrMap.entrySet()) {
                MeasureOptionEntry optionEntry = optionMap.get(entry.getKey());
                if (optionEntry == null) {
                    System.err.println("WARNING: Not found specified option key: " + (String)entry.getKey());
                    continue;
                }
                List<String> candidates = optionEntry.getCandidateList();
                if (candidates != null && !candidates.contains(entry.getValue())) {
                    System.err.println("WARNING: Specified option value is not allowed: " + (String)entry.getKey() + "=" + (String)entry.getValue());
                    continue;
                }
                optionEntry.setValue((String)entry.getValue());
            }
        }
        System.err.println("Checking package options...");
        for (MeasureOptionEntry measureOptionEntry : optionMap.values()) {
            System.err.printf("  %s: %s%n", measureOptionEntry.getKey(), measureOptionEntry.getValue());
        }
        System.err.println("Doing detection...");
        WholeTask wholeTask = new WholeTask(this.targetPathList, this.storagePathList, this.filter, measurerPackage.getHandler(), optionMap, this.numThreads, STDERR_PROGRESS_LISTENER);
        Object simGroupList = null;
        try {
            simGroupList = wholeTask.call();
        }
        catch (InterruptedException e) {
            System.err.println("Aborted");
            return false;
        }
        LinkedHashMap<String, Long> fidMap = new LinkedHashMap<String, Long>(simGroupList.size() * 2, 0.9f);
        long genid = 0L;
        Iterator iterator = simGroupList.iterator();
        while (iterator.hasNext()) {
            SimilarGroup simGroup = (SimilarGroup)iterator.next();
            if (!fidMap.containsKey(simGroup.getFileEntry().getPath())) {
                fidMap.put(simGroup.getFileEntry().getPath(), genid++);
            }
            for (SimilarEntry sim : simGroup.getSimilarList()) {
                if (fidMap.containsKey(sim.getFileEntry().getPath())) continue;
                fidMap.put(sim.getFileEntry().getPath(), genid++);
            }
        }
        System.err.println("Writing the result...");
        this.printInXML(fidMap, (List<SimilarGroup>)simGroupList);
        return true;
    }

    private void printInXML(Map<String, Long> fidMap, List<SimilarGroup> simGroupList) {
        System.out.println("<?xml version=\"1.0\"?>");
        System.out.println("<result>");
        for (Map.Entry<String, Long> entry : fidMap.entrySet()) {
            System.out.printf("  <file id=\"%d\" path=\"%s\" />%n", entry.getValue(), new File(entry.getKey()).getAbsolutePath());
        }
        for (SimilarGroup simGroup : simGroupList) {
            System.out.printf("  <simgroup file=\"%d\">%n", fidMap.get(simGroup.getFileEntry().getPath()));
            for (SimilarEntry sim : simGroup.getSimilarList()) {
                System.out.printf("    <simitem distance=\"%d\" file=\"%d\" />%n", sim.getDistance(), fidMap.get(sim.getFileEntry().getPath()));
            }
            System.out.println("  </simgroup>");
        }
        System.out.println("</result>");
    }
}

