/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jp.thisnor.dre.app.Application;
import jp.thisnor.dre.app.DREPage;
import jp.thisnor.dre.app.DisposeExecutePage;
import jp.thisnor.dre.app.DisposeWaySelectPage;
import jp.thisnor.dre.app.FileEntrySelectPage;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.MeasureExecutePage;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.app.PackageSelectPage;
import jp.thisnor.dre.app.PrefsDialog;
import jp.thisnor.dre.app.SimilarEntrySelectPage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

class DREFrame {
    private static final String PREFERENCES_PATH = "prefs";
    private static final String PREFS_LANGUAGE_KEY = String.valueOf(DREFrame.class.getName()) + ".lang";
    private static final String PREFS_SHELL_WIDTH_KEY = String.valueOf(DREFrame.class.getName()) + ".width";
    private static final String PREFS_SHELL_HEIGHT_KEY = String.valueOf(DREFrame.class.getName()) + ".height";
    private PreferenceStore prefs;
    private Messages messages;
    private Map<Class<? extends DREPage>, DREPage> pageMap;
    private DREPage currentPage;
    private Shell shell;
    private Composite titleBar;
    private Label pageTitleLabel;
    private Label pageDescLabel;
    private Composite contentComp;
    private StackLayout contentStack;
    private Button prefsButton;
    private Button prevButton;
    private Button nextButton;
    private Button closeButton;
    private final SelectionListener PREFS_BUTTON_SELECTED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            PrefsDialog dialog = new PrefsDialog(DREFrame.this);
            dialog.open();
        }
    };
    private final SelectionListener PREV_BUTTON_SELECTED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DREFrame.this.currentPage.previousRequested();
        }
    };
    private final SelectionListener NEXT_BUTTON_SELECTED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DREFrame.this.currentPage.nextRequested();
        }
    };
    private final SelectionListener CLOSE_BUTTON_SELECTED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DREFrame.this.shell.close();
        }
    };
    private final ShellListener SHELL_CLOSED = new ShellAdapter(){

        public void shellClosed(ShellEvent event) {
            MessageBox msgBox = new MessageBox(DREFrame.this.shell, 192);
            msgBox.setText(DREFrame.this.messages.getString("DREFrame.CONFIRM_CLOSE_TITLE"));
            msgBox.setMessage(DREFrame.this.messages.getString("DREFrame.CONFIRM_CLOSE_MESSAGE"));
            int ret = msgBox.open();
            boolean bl = event.doit = ret == 64;
            if (event.doit) {
                DREFrame.this.setActivePage(null);
                DREFrame.this.prefs.setValue(PREFS_SHELL_WIDTH_KEY, ((DREFrame)DREFrame.this).shell.getSize().x);
                DREFrame.this.prefs.setValue(PREFS_SHELL_HEIGHT_KEY, ((DREFrame)DREFrame.this).shell.getSize().y);
            }
        }
    };

    DREFrame() {
    }

    PreferenceStore getPreferences() {
        return this.prefs;
    }

    Messages getMessages() {
        return this.messages;
    }

    <T extends DREPage> T getPage(Class<T> cls) {
        return (T)((DREPage)cls.cast(this.pageMap.get(cls)));
    }

    void setActivePage(DREPage page) {
        if (this.currentPage != null) {
            this.currentPage.hiddened();
        }
        this.currentPage = page;
        if (page != null) {
            page.activated();
        }
    }

    void setPageTitle(String title) {
        this.pageTitleLabel.setText(title);
        this.titleBar.layout();
    }

    void setPageDescription(String desc) {
        this.pageDescLabel.setText(desc);
        this.titleBar.layout();
    }

    void setContent(Control cont) {
        this.contentStack.topControl = cont;
        this.contentComp.layout();
        this.contentComp.redraw();
    }

    void setPreviousButtonEnabled(boolean enabled) {
        this.prevButton.setEnabled(enabled);
    }

    void setNextButtonEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
    }

    void setCancelButtonEnabled(boolean enabled) {
        this.closeButton.setEnabled(enabled);
    }

    void open() {
        this.prefs = new PreferenceStore(PREFERENCES_PATH);
        try {
            this.prefs.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.prefs.setDefault(PREFS_LANGUAGE_KEY, Locale.getDefault().getLanguage());
        this.prefs.setDefault(PREFS_SHELL_WIDTH_KEY, 840);
        this.prefs.setDefault(PREFS_SHELL_HEIGHT_KEY, 540);
        this.messages = new Messages(new Locale(this.prefs.getString(PREFS_LANGUAGE_KEY)), this.getClass().getClassLoader());
        this.pageMap = new HashMap<Class<? extends DREPage>, DREPage>();
        this.putPage(FileEntrySelectPage.class, new FileEntrySelectPage(this));
        this.putPage(PackageSelectPage.class, new PackageSelectPage(this));
        this.putPage(MeasureExecutePage.class, new MeasureExecutePage(this));
        this.putPage(SimilarEntrySelectPage.class, new SimilarEntrySelectPage(this));
        this.putPage(DisposeWaySelectPage.class, new DisposeWaySelectPage(this));
        this.putPage(DisposeExecutePage.class, new DisposeExecutePage(this));
        Display display = new Display();
        this.shell = new Shell(display);
        this.shell.setText(String.valueOf(Application.APP_NAME) + " " + Application.VERSION);
        this.shell.setSize(this.prefs.getInt(PREFS_SHELL_WIDTH_KEY), this.prefs.getInt(PREFS_SHELL_HEIGHT_KEY));
        FormLayout l22 = new FormLayout();
        this.shell.setLayout((Layout)l22);
        this.shell.addShellListener(this.SHELL_CLOSED);
        this.createContents((Composite)this.shell);
        this.setActivePage(this.getPage(FileEntrySelectPage.class));
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        try {
            this.prefs.save();
        }
        catch (IOException l22) {
            // empty catch block
        }
        for (DREPage page : this.pageMap.values()) {
            page.dispose();
        }
        display.dispose();
    }

    private <T extends DREPage> void putPage(Class<T> cls, T obj) {
        this.pageMap.put(cls, obj);
    }

    private void createContents(Composite parent) {
        this.titleBar = new Composite(parent, 0);
        this.titleBar.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        RowLayout l = new RowLayout(512);
        l.marginHeight = 8;
        l.marginWidth = 8;
        this.titleBar.setLayout((Layout)l);
        this.pageTitleLabel = new Label(this.titleBar, 0);
        this.pageTitleLabel.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        this.pageTitleLabel.setFont(new Font((Device)Display.getCurrent(), Display.getCurrent().getSystemFont().getFontData()[0].getName(), Display.getCurrent().getSystemFont().getFontData()[0].getHeight(), 1));
        this.pageDescLabel = new Label(this.titleBar, 0);
        this.pageDescLabel.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        Group contentGroup = new Group(parent, 0);
        FillLayout l2 = new FillLayout();
        l2.marginHeight = 8;
        l2.marginWidth = 8;
        contentGroup.setLayout((Layout)l2);
        this.contentComp = new Composite((Composite)contentGroup, 0);
        this.contentStack = new StackLayout();
        this.contentComp.setLayout((Layout)this.contentStack);
        Composite buttonBar = new Composite(parent, 0);
        FormLayout l3 = new FormLayout();
        l3.marginHeight = 8;
        l3.marginWidth = 8;
        l3.spacing = 8;
        buttonBar.setLayout((Layout)l3);
        this.prefsButton = new Button(buttonBar, 8);
        this.prefsButton.setText(this.messages.getString("DREFrame.CONFIG_BUTTON_TEXT"));
        this.prefsButton.addSelectionListener(this.PREFS_BUTTON_SELECTED);
        this.prevButton = new Button(buttonBar, 8);
        this.prevButton.setText(this.messages.getString("DREFrame.BACK_BUTTON_TEXT"));
        this.prevButton.addSelectionListener(this.PREV_BUTTON_SELECTED);
        this.nextButton = new Button(buttonBar, 8);
        this.nextButton.setText(this.messages.getString("DREFrame.NEXT_BUTTON_TEXT"));
        this.nextButton.addSelectionListener(this.NEXT_BUTTON_SELECTED);
        this.closeButton = new Button(buttonBar, 8);
        this.closeButton.setText(this.messages.getString("DREFrame.CLOSE_BUTTON_TEXT"));
        this.closeButton.addSelectionListener(this.CLOSE_BUTTON_SELECTED);
        this.prefsButton.setLayoutData((Object)new FormDataBuilder().left(0).width(120).height(30).build());
        this.prevButton.setLayoutData((Object)new FormDataBuilder().width(120).right((Control)this.nextButton).height(30).build());
        this.nextButton.setLayoutData((Object)new FormDataBuilder().width(120).right((Control)this.closeButton).height(30).build());
        this.closeButton.setLayoutData((Object)new FormDataBuilder().width(80).right(100).height(30).build());
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.titleBar.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.titleBar);
        fd.bottom = new FormAttachment((Control)buttonBar);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        contentGroup.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        buttonBar.setLayoutData((Object)fd);
        for (DREPage page : this.pageMap.values()) {
            page.createContents(this.contentComp);
        }
    }

    Shell getShell() {
        return this.shell;
    }
}

