/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.DREPage;
import jp.thisnor.dre.app.FileEntrySelectPage;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.app.PackageSelectPage;
import jp.thisnor.dre.app.SimilarEntrySelectPage;
import jp.thisnor.dre.core.MeasureOptionEntry;
import jp.thisnor.dre.core.Measurer;
import jp.thisnor.dre.core.PathFilter;
import jp.thisnor.dre.core.ProgressListener;
import jp.thisnor.dre.core.SimilarGroup;
import jp.thisnor.dre.core.WholeTask;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

class MeasureExecutePage
extends DREPage {
    private DREFrame frame;
    private Messages messages;
    private Composite rootComp;
    private ProgressBar loadProgress;
    private ProgressBar measureProgress;
    private Text logText;
    private ExecutorService executor;
    private volatile List<SimilarGroup> simGroupList;

    MeasureExecutePage(DREFrame frame) {
        this.frame = frame;
        this.messages = frame.getMessages();
    }

    List<SimilarGroup> getSimilarGroupList() {
        return this.simGroupList;
    }

    @Override
    void createContents(Composite parent) {
        this.rootComp = new SashForm(parent, 512);
        Composite progressComp = new Composite(this.rootComp, 0);
        FormLayout l = new FormLayout();
        l.spacing = 8;
        progressComp.setLayout((Layout)l);
        Label loadProgressLabel = new Label(progressComp, 0);
        loadProgressLabel.setText(this.messages.getString("MeasureExecutePage.LOAD_PROGRESS"));
        this.loadProgress = new ProgressBar(progressComp, 0);
        this.loadProgress.setMinimum(0);
        Label measureProgressLabel = new Label(progressComp, 0);
        measureProgressLabel.setText(this.messages.getString("MeasureExecutePage.MEASURE_PROGRESS"));
        this.measureProgress = new ProgressBar(progressComp, 0);
        this.measureProgress.setMinimum(0);
        loadProgressLabel.setLayoutData((Object)new FormDataBuilder().left(0).right(0, 160).top(0).build());
        this.loadProgress.setLayoutData((Object)new FormDataBuilder().left((Control)loadProgressLabel).right(100).top(0).build());
        measureProgressLabel.setLayoutData((Object)new FormDataBuilder().left(0).right(0, 160).top((Control)loadProgressLabel).build());
        this.measureProgress.setLayoutData((Object)new FormDataBuilder().left((Control)measureProgressLabel).right(100).top((Control)loadProgressLabel).build());
        this.logText = new Text(this.rootComp, 2570);
    }

    @Override
    void activated() {
        this.frame.setPageTitle(this.messages.getString("MeasureExecutePage.PAGE_TITLE"));
        this.frame.setPageDescription(this.messages.getString("MeasureExecutePage.PAGE_DESCRIPTION"));
        this.frame.setContent((Control)this.rootComp);
        this.frame.setPreviousButtonEnabled(true);
        this.frame.setNextButtonEnabled(false);
        FileEntrySelectPage fileSelectPage = this.frame.getPage(FileEntrySelectPage.class);
        final List<String> targetFileList = fileSelectPage.getExtTargetFileList();
        final List<String> storageFileList = fileSelectPage.getExtStorageFileList();
        final PathFilter filter = fileSelectPage.getPathFilter();
        PackageSelectPage packageSelectPage = this.frame.getPage(PackageSelectPage.class);
        final Measurer measurer = packageSelectPage.getSelectedPackage().getHandler();
        final Map<String, MeasureOptionEntry> optionMap = packageSelectPage.getSelectedPackage().getOptionMap();
        final int numThreads = packageSelectPage.getNumThreads();
        final ProgressListener logger = new ProgressListener(){

            @Override
            public void progressLoad(final int step, final int size) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MeasureExecutePage.this.loadProgress.isDisposed()) {
                            return;
                        }
                        MeasureExecutePage.this.loadProgress.setSelection(step);
                        MeasureExecutePage.this.loadProgress.setMaximum(size);
                    }
                });
            }

            @Override
            public void progressMeasure(final int step, final int size) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MeasureExecutePage.this.measureProgress.isDisposed()) {
                            return;
                        }
                        MeasureExecutePage.this.measureProgress.setSelection(step);
                        MeasureExecutePage.this.measureProgress.setMaximum(size);
                    }
                });
            }

            @Override
            public void log(final String line) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MeasureExecutePage.this.logText.isDisposed()) {
                            return;
                        }
                        MeasureExecutePage.this.logText.append(String.valueOf(line) + "\n");
                    }
                });
            }
        };
        this.loadProgress.setSelection(0);
        this.measureProgress.setSelection(0);
        this.logText.setText("");
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                WholeTask task = new WholeTask(targetFileList, storageFileList, filter, measurer, optionMap, numThreads, logger);
                try {
                    task.call();
                    logger.log("Finished.");
                }
                catch (InterruptedException e) {
                    logger.log("Aborted.");
                }
                MeasureExecutePage.this.simGroupList = task.getResult();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MeasureExecutePage.this.frame.setNextButtonEnabled(true);
                    }
                });
            }
        });
        this.executor.shutdown();
    }

    @Override
    void hiddened() {
        if (this.executor != null && !this.executor.isTerminated()) {
            this.executor.shutdownNow();
        }
        this.executor = null;
    }

    @Override
    void nextRequested() {
        this.frame.setActivePage(this.frame.getPage(SimilarEntrySelectPage.class));
    }

    @Override
    void previousRequested() {
        if (this.executor != null && !this.executor.isTerminated()) {
            MessageBox msgBox = new MessageBox(Display.getCurrent().getActiveShell(), 192);
            msgBox.setText(this.messages.getString("MeasureExecutePage.CONFIRM_ABORT_TITLE"));
            msgBox.setMessage(this.messages.getString("MeasureExecutePage.CONFIRM_ABORT_MESSAGE"));
            if (msgBox.open() == 128) {
                return;
            }
        }
        this.frame.setActivePage(this.frame.getPage(PackageSelectPage.class));
    }

    @Override
    void dispose() {
    }
}

