/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.thisnor.dre.app.EntrySelecter;
import jp.thisnor.dre.core.FileEntry;
import jp.thisnor.dre.core.SimilarEntry;
import jp.thisnor.dre.core.SimilarGroup;

class PathFilterEntrySelecter
implements EntrySelecter {
    private final String filterPath;

    PathFilterEntrySelecter(String path) {
        this.filterPath = path.toLowerCase();
    }

    @Override
    public Set<FileEntry> select(List<SimilarGroup> simGroupList) {
        HashSet<FileEntry> resultSet = new HashSet<FileEntry>();
        for (SimilarGroup simGroup : simGroupList) {
            FileEntry file = simGroup.getFileEntry();
            if (this.hit(file)) {
                resultSet.add(file);
            }
            for (SimilarEntry similar : simGroup.getSimilarList()) {
                FileEntry simFile = similar.getFileEntry();
                if (!this.hit(simFile)) continue;
                resultSet.add(simFile);
            }
        }
        return resultSet;
    }

    private boolean hit(FileEntry file) {
        return file.getPath().toLowerCase().startsWith(this.filterPath);
    }
}

