/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.DREPage;
import jp.thisnor.dre.app.DisposeWaySelectPage;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.ImagePreviewer;
import jp.thisnor.dre.app.MeasureExecutePage;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.app.PackageSelectPage;
import jp.thisnor.dre.app.SimilarEntryCheckerViewer;
import jp.thisnor.dre.core.FileEntry;
import jp.thisnor.dre.core.NormalFileEntry;
import jp.thisnor.dre.core.SimilarEntry;
import jp.thisnor.dre.core.SimilarGroup;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class SimilarEntrySelectPage
extends DREPage {
    private final DREFrame frame;
    private Messages messages;
    private SashForm rootComp;
    private Composite fileEntryComp;
    private Label fileEntryLabel;
    private Table fileEntryTable;
    private Composite similarEntryComp;
    private Label similarEntryLabel;
    private TableViewer similarEntryTableViewer;
    private ImagePreviewer previewer;
    private SimilarEntryCheckerViewer checkerViewer;
    private List<SimilarGroup> simGroupList;
    private Set<FileEntry> checkedFileSet;
    private ExecutorService appendEntryExecutor;
    private final Runnable APPEND_ENTRIES_TASK = new Runnable(){

        @Override
        public void run() {
            boolean first = true;
            int waitCounter = 32;
            for (final SimilarGroup entry : SimilarEntrySelectPage.this.simGroupList) {
                final boolean ffirst = first;
                first = false;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SimilarEntrySelectPage.this.fileEntryTable.isDisposed()) {
                            return;
                        }
                        TableItem item = new TableItem(SimilarEntrySelectPage.this.fileEntryTable, 0);
                        item.setText(0, entry.getFileEntry().getName());
                        item.setText(1, Integer.toString(entry.getSimilarList().get(0).getDistance()));
                        item.setData((Object)entry);
                        if (SimilarEntrySelectPage.this.checkedFileSet.contains(entry.getFileEntry())) {
                            item.setChecked(true);
                        }
                        if (ffirst) {
                            SimilarEntrySelectPage.this.setActiveFileEntryItem(item);
                            SimilarEntrySelectPage.this.fileEntryTable.setSelection(0);
                        }
                    }
                });
                if (--waitCounter != 0) continue;
                try {
                    Thread.sleep(16L);
                }
                catch (InterruptedException e) {
                    break;
                }
                waitCounter = 32;
            }
        }
    };
    private final SelectionListener FILE_TABLE_SELECTION_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            TableItem item = (TableItem)event.item;
            SimilarEntrySelectPage.this.setActiveFileEntryItem(item);
        }
    };
    private final KeyListener FILE_TABLE_SHIFT_LISTENER = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 131072) {
                SimilarEntrySelectPage.this.similarEntryTableViewer.getTable().forceFocus();
            }
        }
    };
    private final IContentProvider SIMILAR_TABLE_CONTENT_PROVIDER = new ArrayContentProvider(){

        public Object[] getElements(Object inputElement) {
            SimilarGroup simGroup = (SimilarGroup)inputElement;
            Object[] array = new Object[simGroup.getSimilarList().size() + 1];
            array[0] = new SimilarEntry(simGroup.getFileEntry(), 0);
            int i = 1;
            while (i < array.length) {
                array[i] = simGroup.getSimilarList().get(i - 1);
                ++i;
            }
            return array;
        }
    };
    private final ITableLabelProvider SIMILAR_TABLE_LABEL_PROVIDER = new ITableLabelProvider(){

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object element, int index) {
            SimilarEntry similar = (SimilarEntry)element;
            return index == 0 ? similar.getFileEntry().getName() : Integer.toString(similar.getDistance());
        }
    };
    private final ISelectionChangedListener SIMILAR_TABLE_SELECTED = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SimilarEntry similar = (SimilarEntry)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (similar != null) {
                SimilarEntrySelectPage.this.previewer.setFileEntry(similar.getFileEntry());
            }
        }
    };
    private final KeyListener SIMILAR_TABLE_SHIFT_LISTENER = new KeyAdapter(){

        public void keyReleased(KeyEvent event) {
            if (event.keyCode == 131072) {
                SimilarEntrySelectPage.this.fileEntryTable.forceFocus();
            }
        }
    };
    private final SelectionListener FILE_TABLE_CHECK_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (event.detail != 32) {
                return;
            }
            TableItem item = (TableItem)event.item;
            FileEntry file = ((SimilarGroup)item.getData()).getFileEntry();
            SimilarEntrySelectPage.this.setFileChecked(file, item.getChecked());
        }
    };
    private final SelectionListener SIMILAR_TABLE_CHECK_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (event.detail != 32) {
                return;
            }
            TableItem item = (TableItem)event.item;
            FileEntry file = ((SimilarEntry)item.getData()).getFileEntry();
            SimilarEntrySelectPage.this.setFileChecked(file, item.getChecked());
        }
    };
    private final KeyListener COMMON_TABLE_KEY_LISTENER = new KeyListener(){

        public void keyPressed(KeyEvent event) {
            switch (event.keyCode) {
                case 262144: {
                    SimilarEntrySelectPage.this.previewer.setLoupeEnabled(true);
                    SimilarEntrySelectPage.this.previewer.setMouseDown(true);
                }
            }
        }

        public void keyReleased(KeyEvent event) {
            switch (event.keyCode) {
                case 262144: {
                    SimilarEntrySelectPage.this.previewer.setLoupeEnabled(false);
                    SimilarEntrySelectPage.this.previewer.setMouseDown(false);
                }
            }
        }
    };

    SimilarEntrySelectPage(DREFrame frame) {
        this.frame = frame;
        this.messages = frame.getMessages();
        this.checkedFileSet = Collections.synchronizedSet(new HashSet());
    }

    @Override
    void createContents(Composite parent) {
        this.rootComp = new SashForm(parent, 256);
        this.rootComp.setSashWidth(8);
        SashForm entryTableComp = new SashForm((Composite)this.rootComp, 512);
        entryTableComp.setSashWidth(8);
        this.fileEntryComp = new Composite((Composite)entryTableComp, 0);
        this.fileEntryComp.setLayout((Layout)new FormLayout());
        this.fileEntryLabel = new Label(this.fileEntryComp, 0);
        this.fileEntryLabel.setText(this.messages.getString("SimilarEntrySelectPage.FILE_TABLE_CAPTION"));
        Label fileEntryControlLabel = new Label(this.fileEntryComp, 0);
        fileEntryControlLabel.setText(this.messages.getString("SimilarEntrySelectPage.FILE_TABLE_CONTROL_CAPTION"));
        fileEntryControlLabel.setForeground(Display.getDefault().getSystemColor(33));
        this.fileEntryTable = new Table(this.fileEntryComp, 2592);
        this.fileEntryTable.addSelectionListener(this.FILE_TABLE_SELECTION_LISTENER);
        this.fileEntryTable.addSelectionListener(this.FILE_TABLE_CHECK_LISTENER);
        this.fileEntryTable.addKeyListener(this.FILE_TABLE_SHIFT_LISTENER);
        this.fileEntryTable.addKeyListener(this.COMMON_TABLE_KEY_LISTENER);
        TableLayout l = new TableLayout();
        l.addColumnData((ColumnLayoutData)new ColumnWeightData(80, true));
        l.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        this.fileEntryTable.setLayout((Layout)l);
        TableColumn entryColumn = new TableColumn(this.fileEntryTable, 0);
        entryColumn.setText(this.messages.getString("SimilarEntrySelectPage.FILE_TABLE.COLUMN.FILE"));
        TableColumn distColumn = new TableColumn(this.fileEntryTable, 0);
        distColumn.setText(this.messages.getString("SimilarEntrySelectPage.FILE_TABLE.COLUMN.DISTANCE"));
        this.fileEntryTable.setHeaderVisible(true);
        this.fileEntryLabel.setLayoutData((Object)new FormDataBuilder().left(0).top(0).build());
        fileEntryControlLabel.setLayoutData((Object)new FormDataBuilder().right(100).top(0).build());
        this.fileEntryTable.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top((Control)this.fileEntryLabel).bottom(100).build());
        this.similarEntryComp = new Composite((Composite)entryTableComp, 0);
        this.similarEntryComp.setLayout((Layout)new FormLayout());
        this.similarEntryLabel = new Label(this.similarEntryComp, 0);
        this.similarEntryLabel.setText(this.messages.getString("SimilarEntrySelectPage.SIMILAR_TABLE_CAPTION"));
        Label similarEntryControlLabel = new Label(this.similarEntryComp, 0);
        similarEntryControlLabel.setText(this.messages.getString("SimilarEntrySelectPage.SIMILAR_TABLE_CONTROL_CAPTION"));
        similarEntryControlLabel.setForeground(Display.getDefault().getSystemColor(33));
        Table similarEntryTable = new Table(this.similarEntryComp, 2592);
        TableColumn entryColumn2 = new TableColumn(similarEntryTable, 0);
        entryColumn2.setText(this.messages.getString("SimilarEntrySelectPage.SIMILAR_TABLE.COLUMN.FILE"));
        TableColumn distColumn2 = new TableColumn(similarEntryTable, 0);
        distColumn2.setText(this.messages.getString("SimilarEntrySelectPage.SIMILAR_TABLE.COLUMN.DISTANCE"));
        similarEntryTable.setHeaderVisible(true);
        this.similarEntryTableViewer = new TableViewer(similarEntryTable);
        this.similarEntryTableViewer.setContentProvider(this.SIMILAR_TABLE_CONTENT_PROVIDER);
        this.similarEntryTableViewer.setLabelProvider((IBaseLabelProvider)this.SIMILAR_TABLE_LABEL_PROVIDER);
        this.similarEntryTableViewer.addSelectionChangedListener(this.SIMILAR_TABLE_SELECTED);
        similarEntryTable.addSelectionListener(this.SIMILAR_TABLE_CHECK_LISTENER);
        similarEntryTable.addKeyListener(this.SIMILAR_TABLE_SHIFT_LISTENER);
        similarEntryTable.addKeyListener(this.COMMON_TABLE_KEY_LISTENER);
        TableLayout l2 = new TableLayout();
        l2.addColumnData((ColumnLayoutData)new ColumnWeightData(80, true));
        l2.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        similarEntryTable.setLayout((Layout)l2);
        this.similarEntryLabel.setLayoutData((Object)new FormDataBuilder().left(0).top(0).build());
        similarEntryControlLabel.setLayoutData((Object)new FormDataBuilder().right(100).top(0).build());
        similarEntryTable.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top((Control)this.similarEntryLabel).bottom(100).build());
        TabFolder tabFolder = new TabFolder((Composite)this.rootComp, 0);
        Composite previewerComp = new Composite((Composite)tabFolder, 0);
        FillLayout l3 = new FillLayout();
        l3.marginHeight = 8;
        l3.marginWidth = 8;
        previewerComp.setLayout((Layout)l3);
        this.previewer = new ImagePreviewer(this.frame);
        this.previewer.createContents(previewerComp);
        TabItem previewerTab = new TabItem(tabFolder, 0);
        previewerTab.setText(this.messages.getString("SimilarEntrySelectPage.TAB.PREVIEWER"));
        previewerTab.setControl((Control)previewerComp);
        Composite checkerComp = new Composite((Composite)tabFolder, 0);
        FillLayout l4 = new FillLayout();
        l4.marginHeight = 8;
        l4.marginWidth = 8;
        checkerComp.setLayout((Layout)l4);
        this.checkerViewer = new SimilarEntryCheckerViewer(this.frame);
        this.checkerViewer.createContents(checkerComp);
        TabItem checkerTab = new TabItem(tabFolder, 0);
        checkerTab.setText(this.messages.getString("SimilarEntrySelectPage.TAB.CHECKER"));
        checkerTab.setControl((Control)checkerComp);
    }

    Set<FileEntry> getCheckedFileSet() {
        return this.checkedFileSet;
    }

    void setFileChecked(Set<FileEntry> fileEntrySet, int mode) {
        switch (mode) {
            case 0: {
                this.checkedFileSet.removeAll(fileEntrySet);
                break;
            }
            case 1: {
                this.checkedFileSet.addAll(fileEntrySet);
                break;
            }
            case -1: {
                for (FileEntry entry : fileEntrySet) {
                    if (this.checkedFileSet.contains(entry)) {
                        this.checkedFileSet.remove(entry);
                        continue;
                    }
                    this.checkedFileSet.add(entry);
                }
                break;
            }
        }
        this.updateFileTableCheckState();
        this.updateSimilarTableCheckState();
    }

    void setFileChecked(FileEntry file, boolean checked) {
        if (checked) {
            this.checkedFileSet.add(file);
        } else {
            this.checkedFileSet.remove(file);
        }
        this.updateFileTableCheckState();
        this.updateSimilarTableCheckState();
    }

    void updateFileTableCheckState() {
        TableItem[] tableItemArray = this.fileEntryTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            SimilarGroup simGroup = (SimilarGroup)item.getData();
            item.setChecked(this.checkedFileSet.contains(simGroup.getFileEntry()));
            ++n2;
        }
    }

    void updateSimilarTableCheckState() {
        TableItem[] tableItemArray = this.similarEntryTableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            SimilarEntry similar = (SimilarEntry)item.getData();
            item.setChecked(this.checkedFileSet.contains(similar.getFileEntry()));
            ++n2;
        }
    }

    private void setActiveFileEntryItem(TableItem item) {
        SimilarGroup simGroup = (SimilarGroup)item.getData();
        this.similarEntryTableViewer.setInput((Object)simGroup);
        this.similarEntryTableViewer.getTable().setSelection(0);
        TableItem[] tableItemArray = this.similarEntryTableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem simItem = tableItemArray[n2];
            SimilarEntry similar = (SimilarEntry)simItem.getData();
            if (this.checkedFileSet.contains(similar.getFileEntry())) {
                simItem.setChecked(true);
            }
            ++n2;
        }
        this.previewer.setFileEntry(simGroup.getFileEntry());
        this.similarEntryLabel.setText(String.valueOf(this.messages.getString("SimilarEntrySelectPage.SIMILAR_TABLE_CAPTION")) + " (" + (simGroup.getSimilarList().size() + 1) + ")");
        this.similarEntryComp.layout();
    }

    @Override
    void activated() {
        this.frame.setPageTitle(this.messages.getString("SimilarEntrySelectPage.PAGE_TITLE"));
        this.frame.setPageDescription(this.messages.getString("SimilarEntrySelectPage.PAGE_DESCRIPTION"));
        this.frame.setContent((Control)this.rootComp);
        this.frame.setNextButtonEnabled(true);
        this.frame.setPreviousButtonEnabled(true);
        this.simGroupList = this.frame.getPage(MeasureExecutePage.class).getSimilarGroupList();
        Iterator<SimilarGroup> it = this.simGroupList.iterator();
        while (it.hasNext()) {
            SimilarGroup simGroup = it.next();
            FileEntry fileEntry = simGroup.getFileEntry();
            if (fileEntry instanceof NormalFileEntry && !new File(fileEntry.getPath()).exists()) {
                it.remove();
                continue;
            }
            List<SimilarEntry> simList = simGroup.getSimilarList();
            Iterator<SimilarEntry> it2 = simList.iterator();
            while (it2.hasNext()) {
                FileEntry simFileEntry = it2.next().getFileEntry();
                if (!(simFileEntry instanceof NormalFileEntry) || new File(simFileEntry.getPath()).exists()) continue;
                it2.remove();
            }
            if (!simList.isEmpty()) continue;
            it.remove();
        }
        this.fileEntryTable.removeAll();
        this.similarEntryTableViewer.getTable().removeAll();
        this.previewer.setFileEntry(null);
        this.checkedFileSet.clear();
        this.fileEntryLabel.setText(String.valueOf(this.messages.getString("SimilarEntrySelectPage.FILE_TABLE_CAPTION")) + " (" + this.simGroupList.size() + ")");
        this.fileEntryComp.layout();
        this.similarEntryLabel.setText(this.messages.getString("SimilarEntrySelectPage.SIMILAR_TABLE_CAPTION"));
        this.similarEntryComp.layout();
        this.appendEntryExecutor = Executors.newSingleThreadExecutor();
        this.appendEntryExecutor.execute(this.APPEND_ENTRIES_TASK);
    }

    @Override
    void hiddened() {
        if (!this.appendEntryExecutor.isShutdown()) {
            this.appendEntryExecutor.shutdownNow();
        }
        this.checkerViewer.hiddened();
    }

    @Override
    void nextRequested() {
        this.frame.setActivePage(this.frame.getPage(DisposeWaySelectPage.class));
    }

    @Override
    void previousRequested() {
        MessageBox msgBox = new MessageBox(Display.getCurrent().getActiveShell(), 192);
        msgBox.setText(this.messages.getString("SimilarEntrySelectPage.CONFIRM_BACK_TITLE"));
        msgBox.setMessage(this.messages.getString("SimilarEntrySelectPage.CONFIRM_BACK_MESSAGE"));
        if (msgBox.open() == 128) {
            return;
        }
        this.frame.setActivePage(this.frame.getPage(PackageSelectPage.class));
    }

    @Override
    void dispose() {
    }
}

