/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.thisnor.dre.core.MeasureOptionEntry;
import jp.thisnor.dre.core.Measurer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MeasurerPackage {
    private static final String PACKAGE_DIR = "packages";
    private final String key;
    private final String name;
    private final String version;
    private final String author;
    private final String caption;
    private final String description;
    private final Image image;
    private final Measurer handler;
    private final Map<String, MeasureOptionEntry> optionMap;

    private MeasurerPackage(PackageDescription desc, ClassLoader clsLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.key = desc.key;
        this.name = desc.name;
        this.version = desc.version;
        this.author = desc.author;
        this.caption = desc.caption;
        this.description = desc.description;
        this.image = desc.image != null ? new Image((Device)Display.getCurrent(), clsLoader.getResourceAsStream(desc.image)) : null;
        this.handler = clsLoader.loadClass(desc.handlerClsPath).asSubclass(Measurer.class).newInstance();
        this.optionMap = desc.optionMap;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public Image getImage() {
        return this.image;
    }

    public Measurer getHandler() {
        return this.handler;
    }

    public Map<String, MeasureOptionEntry> getOptionMap() {
        return this.optionMap;
    }

    public static MeasurerPackage importPackage(String packageName) throws IOException {
        try {
            if (new File(PACKAGE_DIR, packageName).isDirectory()) {
                return MeasurerPackage.importDirPackage(new File(PACKAGE_DIR, packageName));
            }
            return MeasurerPackage.importJarPackage(new File(PACKAGE_DIR, String.valueOf(packageName) + ".jar"));
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed in loading package: %s.", packageName), e);
        }
    }

    public static MeasurerPackage importPackage(File packageFile) throws IOException {
        try {
            if (packageFile.isDirectory()) {
                return MeasurerPackage.importDirPackage(packageFile);
            }
            return MeasurerPackage.importJarPackage(packageFile);
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed in loading package: %s.", packageFile.getPath()), e);
        }
    }

    private static MeasurerPackage importJarPackage(File jar) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        PackageDescription desc = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            desc = MeasurerPackage.importPackageDescription(jarFile.getInputStream(jarFile.getEntry("package.xml")));
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        JarPackageClassLoader clsLoader = new JarPackageClassLoader(jar);
        return new MeasurerPackage(desc, clsLoader);
    }

    private static MeasurerPackage importDirPackage(File dir) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        PackageDescription desc = null;
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(String.valueOf(dir.getPath()) + File.separator + "package.xml"));
            desc = MeasurerPackage.importPackageDescription(in);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        DirPackageClassLoader clsLoader = new DirPackageClassLoader(dir);
        return new MeasurerPackage(desc, clsLoader);
    }

    private static PackageDescription importPackageDescription(InputStream in) throws IOException {
        Locale locale = Locale.getDefault();
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = f.newDocumentBuilder();
            Document doc = db.parse(in);
            PackageDescription desc = new PackageDescription();
            Element infoElement = (Element)doc.getElementsByTagName("information").item(0);
            desc.key = MeasurerPackage.getNodeValue(infoElement, "key");
            desc.name = MeasurerPackage.getNodeValue(infoElement, "name", locale);
            desc.version = MeasurerPackage.getNodeValue(infoElement, "version");
            desc.author = MeasurerPackage.getNodeValue(infoElement, "author", locale);
            desc.caption = MeasurerPackage.getNodeValue(infoElement, "caption", locale);
            desc.description = MeasurerPackage.getNodeValue(infoElement, "description", locale);
            desc.image = MeasurerPackage.getNodeValue(infoElement, "icon");
            Element classElement = (Element)doc.getElementsByTagName("class").item(0);
            desc.handlerClsPath = MeasurerPackage.getNodeValue(classElement, "measurer");
            desc.optionMap = new HashMap(8);
            NodeList optionList = doc.getElementsByTagName("option");
            int i = 0;
            while (i < optionList.getLength()) {
                Element optionElement = (Element)optionList.item(i);
                MeasureOptionEntry option = new MeasureOptionEntry(MeasurerPackage.getNodeValue(optionElement, "key"));
                option.setName(MeasurerPackage.getNodeValue(optionElement, "name", locale));
                option.setDefaultValue(MeasurerPackage.getNodeValue(optionElement, "default"));
                NodeList selectNodes = optionElement.getElementsByTagName("select");
                if (selectNodes.getLength() > 0) {
                    ArrayList<String> candList = new ArrayList<String>(4);
                    NodeList valueNodes = ((Element)selectNodes.item(0)).getElementsByTagName("value");
                    int j = 0;
                    while (j < valueNodes.getLength()) {
                        candList.add(valueNodes.item(j).getFirstChild().getNodeValue());
                        ++j;
                    }
                    option.setCandidateList(candList);
                }
                desc.optionMap.put(option.getKey(), option);
                ++i;
            }
            PackageDescription packageDescription = desc;
            return packageDescription;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String getNodeValue(Element element, String tagName) {
        NodeList l = element.getElementsByTagName(tagName);
        if (l.getLength() == 0) {
            return null;
        }
        Node n = l.item(0).getFirstChild();
        if (n.getNodeType() != 3) {
            return null;
        }
        return n.getNodeValue();
    }

    private static String getNodeValue(Element element, String tagName, Locale locale) {
        Node textNode;
        NodeList l = element.getElementsByTagName(tagName);
        if (l.getLength() == 0) {
            return null;
        }
        Node properNode = null;
        int i = 0;
        while (i < l.getLength()) {
            Node n = l.item(i);
            NamedNodeMap attrMap = n.getAttributes();
            Node langNode = attrMap.getNamedItem("lang");
            if (langNode != null && locale.getLanguage().equals(langNode.getNodeValue())) {
                properNode = n;
                break;
            }
            if (properNode == null && langNode == null) {
                properNode = n;
            }
            ++i;
        }
        if (properNode == null) {
            properNode = l.item(0);
        }
        if ((textNode = properNode.getFirstChild()).getNodeType() != 3) {
            return null;
        }
        return textNode.getNodeValue();
    }

    private static class DirPackageClassLoader
    extends ClassLoader {
        private File dir;

        private DirPackageClassLoader(File dir) {
            this.dir = dir;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            InputStream in = null;
            try {
                String path = String.valueOf(this.dir.getPath()) + File.separator + name.replace('.', File.separatorChar) + ".class";
                in = new BufferedInputStream(new FileInputStream(path));
                int len = in.available();
                byte[] buf = new byte[len];
                in.read(buf);
                Class<?> clazz = this.defineClass(name, buf, 0, buf.length);
                return clazz;
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class JarPackageClassLoader
    extends ClassLoader {
        private File file;

        private JarPackageClassLoader(File file) {
            this.file = file;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(this.file);
                ZipEntry zipEntry = jarFile.getEntry(String.valueOf(name.replace('.', '/')) + ".class");
                if (zipEntry == null) {
                    throw new IOException(String.valueOf(name) + ".class");
                }
                InputStream in = jarFile.getInputStream(zipEntry);
                int len = in.available();
                byte[] buf = new byte[len];
                in.read(buf);
                Class<?> clazz = this.defineClass(name, buf, 0, buf.length);
                return clazz;
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class PackageDescription {
        private String key;
        private String name;
        private String version;
        private String author;
        private String caption;
        private String description;
        private String image;
        private String handlerClsPath;
        private Map<String, MeasureOptionEntry> optionMap;

        private PackageDescription() {
        }
    }
}

