/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.math.BigDecimal;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jp.co.nissy.jpicosheet.core.Calculator;
import jp.co.nissy.jpicosheet.core.Element;
import jp.co.nissy.jpicosheet.core.FormulaParser;
import jp.co.nissy.jpicosheet.core.Resolver;
import jp.co.nissy.jpicosheet.core.Sheet;

public class Cell {
    private static Element emptyElement = new Element(Element.ElementType.Empty);
    private final Logger logger = Logger.getLogger("jp.co.nissy.jpicosheet");
    private String _formula;
    private Element[] _formulaRPN;
    private String _name;
    private Sheet _sheet;
    private CellType _cellType = CellType.Empty;
    private CellStatus _status = CellStatus.Caluculated;
    private Element _value;
    static final String CELL_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static Pattern _cellNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    static final String FULLY_QUALIFIED_CELL_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*";
    private static Pattern _fullyQualifiedCellNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*");

    Cell(String cellName, Sheet sheet) throws IllegalArgumentException {
        if (!Cell.isValidCellName(cellName)) {
            throw new IllegalArgumentException("invalid cell name \"" + cellName + "\"");
        }
        this._name = cellName;
        this._formula = "";
        this._value = emptyElement;
        this._sheet = sheet;
    }

    public String getFormula() {
        return this._formula;
    }

    Element[] getFormulaRPN() {
        return this._formulaRPN;
    }

    public String getName() {
        return this._name;
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this._sheet.getName()) + "!" + this._name;
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public CellStatus getStatus() {
        return this._status;
    }

    public String getString() {
        switch (this._value.getType()) {
            case Number: {
                return this._value.getNumber().toString();
            }
            case String: {
                return this._value.getString();
            }
            case Date: {
                return "implementation has not yet.";
            }
        }
        return this._value.toString();
    }

    public Element.ElementType getValueType() {
        return this._value.getType();
    }

    public CellType getCellType() {
        return this._cellType;
    }

    public Element getValue() {
        return this._value;
    }

    void setFormulaRPN(Element[] formulaRPN) {
        this._formulaRPN = formulaRPN;
    }

    void setName(String cellName) throws IllegalArgumentException {
        if (!Cell.isValidCellName(cellName)) {
            throw new IllegalArgumentException("invalid cell name \"" + cellName + "\"");
        }
        this._name = cellName;
    }

    void setStatus(CellStatus status) {
        this._status = status;
    }

    void setValue(Element value) {
        this._value = value;
    }

    public Cell setNumberValue(String numString) {
        this._cellType = CellType.Number;
        this.removeReferenceFromResolver();
        this._value = new Element(Element.ElementType.Number, new BigDecimal(numString, this._sheet.getMathContext()));
        this.getCalculator().calc(this);
        this.clearForumlaMembers();
        return this;
    }

    public Cell setStringValue(String string) {
        this._cellType = CellType.String;
        this.removeReferenceFromResolver();
        this._value = new Element(Element.ElementType.String, string);
        this.getCalculator().calc(this);
        this.clearForumlaMembers();
        return this;
    }

    public Cell setFormula(String formula) {
        this._cellType = CellType.Formula;
        this.removeReferenceFromResolver();
        this._formula = formula;
        Element[] infixElem = FormulaParser.split(this._formula, this._sheet.getMathContext());
        if (infixElem.length == 1 && infixElem[0].getType() == Element.ElementType.Error) {
            this._status = CellStatus.Error;
            this._value = infixElem[0];
            this._sheet.addErrorCell(this);
            return this;
        }
        Element errorElem = FormulaParser.checkInfixNotation(infixElem);
        if (errorElem != null) {
            this._status = CellStatus.Error;
            this._value = errorElem;
            this._sheet.addErrorCell(this);
            return this;
        }
        this._formulaRPN = FormulaParser.infixToRPN(infixElem, this._sheet.getMathContext());
        if (this._formulaRPN.length == 1 && this._formulaRPN[0].getType() == Element.ElementType.Error) {
            this._status = CellStatus.Error;
            this._value = this._formulaRPN[0];
            this._formulaRPN = null;
            this._sheet.addErrorCell(this);
            return this;
        }
        Resolver resolver = this._sheet.getBook().getResolver();
        Element[] elementArray = this._formulaRPN;
        int n = this._formulaRPN.length;
        int n2 = 0;
        while (n2 < n) {
            Element elem = elementArray[n2];
            switch (elem.getType()) {
                case Reference: {
                    resolver.registReferences(this, elem.getCellReference());
                    break;
                }
                case GroupReference: {
                    resolver.registGroupReferences(this, elem.getGroupReference());
                }
            }
            ++n2;
        }
        this._status = CellStatus.RequireCalculation;
        this.getCalculator().calc(this);
        this._sheet.removeErrorCell(this);
        return this;
    }

    private void removeReferenceFromResolver() {
        Resolver resolver = this.getSheet().getBook().getResolver();
        if (this._formulaRPN != null) {
            Element[] elementArray = this._formulaRPN;
            int n = this._formulaRPN.length;
            int n2 = 0;
            while (n2 < n) {
                Element elem = elementArray[n2];
                switch (elem.getType()) {
                    case Reference: {
                        resolver.removeReferences(this, elem.getCellReference());
                    }
                }
                ++n2;
            }
        }
    }

    static boolean isValidCellName(String cellName) {
        return _cellNamePattern.matcher(cellName).matches();
    }

    static boolean isValidFullyQualifiedCellName(String fullyQualifiedCellName) {
        return _fullyQualifiedCellNamePattern.matcher(fullyQualifiedCellName).matches();
    }

    private Calculator getCalculator() {
        return this._sheet.getBook().getCalculator();
    }

    private void clearForumlaMembers() {
        this._formula = null;
        this._formulaRPN = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CellStatus {
        Caluculated,
        Error,
        RequireCalculation,
        UnderCalculation;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CellType {
        Empty,
        Formula,
        Number,
        String;

    }
}

