/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.math.BigDecimal;
import java.util.Date;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.Group;

public class Element {
    private final ElementType _type;
    private final Object _value;
    private int _hashCode = 0;

    public Element(ElementType tokenType, Object value) {
        this._type = tokenType;
        switch (tokenType) {
            case Empty: {
                this._value = null;
                break;
            }
            case Number: {
                if (value instanceof BigDecimal) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("Number\u306e\u5834\u5408\u3001BigDecimal\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case String: {
                if (value instanceof String) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("String\u306e\u5834\u5408\u3001String\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case Date: {
                if (value instanceof Date) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("Date\u306e\u5834\u5408\u3001Date\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case Error: {
                if (value instanceof ErrorType) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("Error\u306e\u5834\u5408\u3001ErrorType\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case Operator: {
                if (value instanceof Operator) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("Operator\u306e\u5834\u5408\u3001\u5217\u6319\u578b Operator\u304c\u5fc5\u8981");
            }
            case Reference: {
                if (value instanceof String) {
                    if (!Cell.isValidCellName((String)value) && !Cell.isValidFullyQualifiedCellName((String)value)) {
                        throw new IllegalArgumentException("\u4e0d\u9069\u5207\u306a\u30bb\u30eb\u540d:" + (String)value);
                    }
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("Reference\u306e\u5834\u5408\u3001String\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case GroupReference: {
                if (!Group.isValidGroupName((String)value) && !Group.isValidFullyQualifiedGroupName((String)value)) {
                    throw new IllegalArgumentException("\u4e0d\u9069\u5207\u306a\u30b0\u30eb\u30fc\u30d7\u540d:" + (String)value);
                }
                if (value instanceof String) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("GroupReference\u306e\u5834\u5408\u3001String\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            default: {
                this._value = null;
            }
        }
    }

    public Element(ElementType tokenType) {
        this._type = tokenType;
        switch (tokenType) {
            case Empty: {
                this._value = null;
                break;
            }
            case Number: {
                this._value = new BigDecimal("0");
                break;
            }
            case String: {
                this._value = "";
                break;
            }
            case Date: {
                this._value = new Date(0L);
                break;
            }
            case Error: {
                throw new IllegalArgumentException("Error\u306e\u5834\u5408\u3001value\u306e\u6307\u5b9a\u304c\u5fc5\u8981");
            }
            case Operator: {
                throw new IllegalArgumentException("Operator\u306e\u5834\u5408\u3001value\u306e\u6307\u5b9a\u304c\u5fc5\u8981");
            }
            case Reference: {
                throw new IllegalArgumentException("Reference\u306e\u5834\u5408\u3001value\u306e\u6307\u5b9a\u304c\u5fc5\u8981");
            }
            case GroupReference: {
                throw new IllegalArgumentException("GroupReference\u306e\u5834\u5408\u3001value\u306e\u6307\u5b9a\u304c\u5fc5\u8981");
            }
            default: {
                this._value = null;
            }
        }
    }

    public ElementType getType() {
        return this._type;
    }

    Object getValue() {
        return this._value;
    }

    public ErrorType getErrorType() throws IllegalStateException {
        if (this._type != ElementType.Error) {
            throw new IllegalStateException("Element type is not Error.");
        }
        return (ErrorType)((Object)this._value);
    }

    public String getCellReference() throws IllegalStateException {
        switch (this._type) {
            case Reference: {
                if (this._value instanceof String) {
                    return (String)this._value;
                }
                throw new IllegalStateException("value is not CellReference");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public String getGroupReference() {
        switch (this._type) {
            case GroupReference: {
                if (this._value instanceof String) {
                    return (String)this._value;
                }
                throw new IllegalStateException("value is not GroupReference");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public Operator getOperator() throws IllegalStateException {
        switch (this._type) {
            case Operator: {
                if (this._value instanceof Operator) {
                    return (Operator)((Object)this._value);
                }
                throw new IllegalStateException("value is not Operator");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public BigDecimal getNumber() throws IllegalStateException {
        switch (this._type) {
            case Empty: {
                return new BigDecimal("0");
            }
            case Number: {
                if (this._value instanceof BigDecimal) {
                    return (BigDecimal)this._value;
                }
                throw new IllegalStateException("value is not number");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public String getString() throws IllegalStateException {
        switch (this._type) {
            case Empty: {
                return "";
            }
            case String: {
                if (this._value instanceof String) {
                    return (String)this._value;
                }
                throw new IllegalStateException("value is not String");
            }
            case Reference: {
                return String.valueOf(this._type.toString()) + ": " + this._value.toString();
            }
            case Error: {
                return String.valueOf(this._type.toString()) + ": " + this._value.toString();
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public Date getDate() throws IllegalStateException {
        switch (this._type) {
            case Empty: {
                return new Date(0L);
            }
            case Date: {
                if (this._value instanceof Date) {
                    return new Date(((Date)this._value).getTime());
                }
                throw new IllegalStateException("value is not Date");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public String toString() {
        if (this._type == ElementType.Empty) {
            return "";
        }
        try {
            return String.valueOf(this._type.toString()) + ":" + this._value.toString();
        }
        catch (IllegalStateException e) {
            return e.getMessage();
        }
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            String concatStr = String.valueOf(Integer.toString(this._type.hashCode())) + Integer.toString(this._value == null ? 0 : this._value.hashCode());
            this._hashCode = concatStr.hashCode();
        }
        return this._hashCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementType {
        Empty,
        Number,
        String,
        Date,
        Error,
        Operator,
        Reference,
        GroupReference;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorType {
        DividedByZero,
        WrongValue,
        InvalidReferences,
        InvalidFormula,
        UnrecognizedName,
        InvalidNumber,
        NotAvailableValue,
        CirculerReference;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        function(-1),
        comma(0),
        leftparenthesis(0),
        rightparenthesis(0),
        plus(1),
        minus(1),
        times(2),
        divided(2),
        unaryPlus(3),
        unaryMinus(3);

        private int _priority;

        private Operator(int priority) {
            this._priority = priority;
        }

        public int evalPriority(Operator arg1) {
            return this._priority - arg1._priority;
        }
    }
}

