/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.nissy.jpicosheet.core.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FormulaParser {
    private static final String SHEETCELL_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*";
    private static final String GROUPCELL_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*@";
    private static final String SPACE_PATTERN = "\\s+";
    private static final String NUMERIC_PATTERN = "(([0-9]+)|([0-9]+\\.[0-9]*)|(\\.[0-9]+))";
    private static final String STRING_PATTERN = "\"[^\"]*\"";
    private static final String FUNCTION_NAME_PATTERN = "[a-zA-Z][a-zA-Z0-9_]*\\(";
    private static Pattern _tokens = Pattern.compile("\\s+|(([0-9]+)|([0-9]+\\.[0-9]*)|(\\.[0-9]+))|\"[^\"]*\"|\\+|-|\\*|/|\\(|\\)|[a-zA-Z][a-zA-Z0-9_]*\\(|,|[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*@|[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*|[a-zA-Z_][a-zA-Z0-9_]*@|[a-zA-Z_][a-zA-Z0-9_]*");
    private static Pattern _cellRefPattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*|[a-zA-Z_][a-zA-Z0-9_]*");
    private static Pattern _groupRefPattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*@|[a-zA-Z_][a-zA-Z0-9_]*@");
    private static Pattern _spacePattern = Pattern.compile("\\s+");
    private static Pattern _numericPattern = Pattern.compile("(([0-9]+)|([0-9]+\\.[0-9]*)|(\\.[0-9]+))");
    private static Pattern _stringPattern = Pattern.compile("\"[^\"]*\"");
    private static Pattern _functionPattern = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*\\(");

    FormulaParser() {
    }

    static Element[] split(String calcString, MathContext mc) {
        ArrayList<Element> list = new ArrayList<Element>();
        Matcher match = _tokens.matcher(calcString);
        int nextStartIndex = 0;
        boolean containsFunction = false;
        while (match.find()) {
            if (nextStartIndex != match.start()) {
                list.clear();
                containsFunction = false;
                list.add(new Element(Element.ElementType.Error, (Object)Element.ErrorType.InvalidFormula));
                break;
            }
            String chunkStr = match.group();
            if (chunkStr.length() == 0) continue;
            if (chunkStr.equals("+") || chunkStr.equals("-")) {
                boolean isUnary = false;
                if (list.size() == 0) {
                    isUnary = true;
                } else if (((Element)list.get(list.size() - 1)).getType() == Element.ElementType.Operator) {
                    switch (((Element)list.get(list.size() - 1)).getOperator()) {
                        case function: 
                        case leftparenthesis: 
                        case plus: 
                        case minus: 
                        case times: 
                        case divided: 
                        case unaryPlus: 
                        case unaryMinus: {
                            isUnary = true;
                            break;
                        }
                        default: {
                            isUnary = false;
                            break;
                        }
                    }
                } else {
                    isUnary = false;
                }
                if (isUnary) {
                    if (chunkStr.equals("+")) {
                        list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.unaryPlus));
                    } else {
                        list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.unaryMinus));
                    }
                } else if (chunkStr.equals("+")) {
                    list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.plus));
                } else {
                    list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.minus));
                }
            } else if (chunkStr.equals("*")) {
                list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.times));
            } else if (chunkStr.equals("/")) {
                list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.divided));
            } else if (_cellRefPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.Reference, chunkStr));
            } else if (_groupRefPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.GroupReference, chunkStr));
            } else if (chunkStr.equals("(")) {
                list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.leftparenthesis));
            } else if (_functionPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.function));
                containsFunction = true;
            } else if (chunkStr.equals(")")) {
                list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.rightparenthesis));
            } else if (chunkStr.equals(",")) {
                list.add(new Element(Element.ElementType.Operator, (Object)Element.Operator.comma));
            } else if (_numericPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.Number, new BigDecimal(chunkStr, mc)));
            } else if (_stringPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.String, chunkStr));
            } else if (!_spacePattern.matcher(chunkStr).matches()) assert (false) : "unknown operator " + chunkStr;
            nextStartIndex = match.end();
        }
        if (containsFunction && list.size() > 1) {
            int i = list.size() - 1;
            while (i >= 0) {
                Element rightElem;
                Element elem = (Element)list.get(i);
                if (elem.getType() == Element.ElementType.Operator && elem.getOperator() == Element.Operator.function && i < list.size() - 1 && ((rightElem = (Element)list.get(i + 1)).getType() != Element.ElementType.Operator || rightElem.getOperator() != Element.Operator.rightparenthesis)) {
                    list.add(i + 1, new Element(Element.ElementType.Operator, (Object)Element.Operator.comma));
                }
                --i;
            }
        }
        Element[] retStrArray = new Element[list.size()];
        retStrArray = list.toArray(retStrArray);
        return retStrArray;
    }

    static Element checkInfixNotation(Element[] infixElem) {
        IndexInfo indexInfo = new IndexInfo(0, infixElem.length);
        return FormulaParser.checkInfixNotation_doCheck(infixElem, indexInfo, null);
    }

    private static Element checkInfixNotation_doCheck(Element[] infixElem, IndexInfo indexInfo, Element.Operator opType) {
        int i = indexInfo.startIndex;
        while (i <= infixElem.length - 1) {
            Element checkElem = infixElem[i];
            Element beforeElem = FormulaParser.getBeforeElem(infixElem, i);
            Element afterElem = FormulaParser.getAfterElem(infixElem, i);
            block0 : switch (checkElem.getType()) {
                case Number: 
                case String: 
                case Date: 
                case Reference: {
                    if (!(beforeElem != null && beforeElem.getType() != Element.ElementType.Operator || afterElem != null && afterElem.getType() != Element.ElementType.Operator)) break;
                    return new Element(Element.ElementType.Error, (Object)Element.ErrorType.InvalidFormula);
                }
                case GroupReference: {
                    if (opType == Element.Operator.function && (beforeElem == null || beforeElem.getType() == Element.ElementType.Operator && beforeElem.getOperator() == Element.Operator.comma || afterElem == null || afterElem.getType() == Element.ElementType.Operator && afterElem.getOperator() == Element.Operator.comma)) break;
                    return new Element(Element.ElementType.Error, (Object)Element.ErrorType.InvalidFormula);
                }
                case Operator: {
                    switch (checkElem.getOperator()) {
                        case unaryPlus: 
                        case unaryMinus: {
                            if (afterElem.getType() == Element.ElementType.Number || afterElem.getType() == Element.ElementType.Reference || afterElem.getType() == Element.ElementType.Operator && afterElem.getOperator() == Element.Operator.unaryPlus || afterElem.getOperator() == Element.Operator.unaryMinus || afterElem.getOperator() == Element.Operator.function || afterElem.getOperator() == Element.Operator.leftparenthesis) break block0;
                            return new Element(Element.ElementType.Error, (Object)Element.ErrorType.InvalidFormula);
                        }
                        case plus: 
                        case minus: 
                        case times: 
                        case divided: {
                            if ((beforeElem.getType() == Element.ElementType.Number || beforeElem.getType() == Element.ElementType.Reference || beforeElem.getType() == Element.ElementType.Operator && beforeElem.getOperator() == Element.Operator.function || beforeElem.getType() == Element.ElementType.Operator && beforeElem.getOperator() == Element.Operator.rightparenthesis) && afterElem.getType() == Element.ElementType.Number || afterElem.getType() == Element.ElementType.Reference || afterElem.getType() == Element.ElementType.Operator && afterElem.getOperator() == Element.Operator.function || afterElem.getType() == Element.ElementType.Operator && afterElem.getOperator() == Element.Operator.leftparenthesis || afterElem.getType() == Element.ElementType.Operator && afterElem.getOperator() == Element.Operator.unaryPlus || afterElem.getType() == Element.ElementType.Operator && afterElem.getOperator() == Element.Operator.unaryMinus) break block0;
                            return new Element(Element.ElementType.Error, (Object)Element.ErrorType.InvalidFormula);
                        }
                        case function: 
                        case leftparenthesis: {
                            indexInfo.startIndex = i + 1;
                            Element elem = FormulaParser.checkInfixNotation_doCheck(infixElem, indexInfo, checkElem.getOperator());
                            if (elem == null) {
                                indexInfo.startIndex = indexInfo.endIndex;
                                i = indexInfo.endIndex;
                                break block0;
                            }
                            return elem;
                        }
                        case comma: {
                            if (opType == Element.Operator.function) break block0;
                            return new Element(Element.ElementType.Error, (Object)Element.ErrorType.InvalidFormula);
                        }
                        case rightparenthesis: {
                            if (opType == Element.Operator.function || opType == Element.Operator.leftparenthesis) {
                                indexInfo.endIndex = i;
                                return null;
                            }
                            return new Element(Element.ElementType.Error, (Object)Element.ErrorType.InvalidFormula);
                        }
                        default: {
                            assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30aa\u30da\u30ec\u30fc\u30bf" + checkElem.getOperator().toString();
                            break block0;
                        }
                    }
                }
                default: {
                    assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30bf\u30a4\u30d7" + checkElem.getType().toString();
                    break;
                }
            }
            ++i;
        }
        if (opType == null) {
            return null;
        }
        return new Element(Element.ElementType.Error, (Object)Element.ErrorType.InvalidFormula);
    }

    private static Element getBeforeElem(Element[] infixElem, int index) {
        if (index < 1) {
            return null;
        }
        return infixElem[index - 1];
    }

    private static Element getAfterElem(Element[] infixElem, int index) {
        if (infixElem.length - 1 <= index) {
            return null;
        }
        return infixElem[index + 1];
    }

    static Element[] infixToRPN(Element[] parsedTokens, MathContext mc) {
        ArrayList<Element> result = new ArrayList<Element>();
        Stack<Element> stack = new Stack<Element>();
        int i = 0;
        while (i < parsedTokens.length) {
            Element token = parsedTokens[i];
            switch (token.getType()) {
                case Number: 
                case String: 
                case Reference: 
                case GroupReference: {
                    result.add(token);
                    break;
                }
                case Operator: {
                    FormulaParser.processOperator(token, stack, result);
                    break;
                }
                default: {
                    assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30c8\u30fc\u30af\u30f3\u306e\u30bf\u30a4\u30d7\u304c\u3042\u3063\u3066\u306f\u306a\u3089\u306a\u3044";
                    break;
                }
            }
            ++i;
        }
        while (!stack.empty()) {
            result.add((Element)stack.pop());
        }
        Element[] retStrArray = new Element[result.size()];
        retStrArray = result.toArray(retStrArray);
        return retStrArray;
    }

    private static void processOperator(Element token, Stack<Element> stack, List<Element> result) {
        block0 : switch (token.getOperator()) {
            case function: 
            case leftparenthesis: {
                stack.add(token);
                break;
            }
            case rightparenthesis: {
                FormulaParser.processRightparenthesis(stack, result);
                break;
            }
            case comma: {
                FormulaParser.processComma(token, stack, result);
                break;
            }
            default: {
                if (stack.empty()) {
                    stack.push(token);
                    break;
                }
                Element.Operator tokenOp = token.getOperator();
                switch (tokenOp) {
                    case plus: 
                    case minus: 
                    case times: 
                    case divided: {
                        Element.Operator peekedOp = stack.peek().getOperator();
                        if (peekedOp == Element.Operator.unaryPlus || peekedOp == Element.Operator.unaryMinus) {
                            while (!(stack.empty() || peekedOp != Element.Operator.unaryPlus && peekedOp != Element.Operator.unaryMinus)) {
                                result.add(stack.pop());
                            }
                        }
                        if (!stack.empty() && peekedOp.evalPriority(tokenOp) >= 0) {
                            result.add(stack.pop());
                            stack.push(token);
                            break block0;
                        }
                        stack.push(token);
                        break block0;
                    }
                }
                stack.push(token);
            }
        }
    }

    private static void processRightparenthesis(Stack<Element> stack, List<Element> result) {
        while (true) {
            if (stack.size() == 0) assert (false) : "invalid parenthesis.";
            Element poppedElem = stack.pop();
            if (poppedElem.getOperator() == Element.Operator.leftparenthesis) break;
            if (poppedElem.getOperator() == Element.Operator.function) {
                result.add(poppedElem);
                break;
            }
            result.add(poppedElem);
        }
    }

    private static void processComma(Element token, Stack<Element> stack, List<Element> result) {
        while (true) {
            if (stack.empty()) assert (false) : "invalid comma.";
            Element peekedElem = stack.peek();
            if (peekedElem.getOperator() == Element.Operator.comma || peekedElem.getOperator() == Element.Operator.function) break;
            result.add(stack.pop());
        }
        stack.push(token);
    }

    private static class IndexInfo {
        int startIndex = 0;
        int endIndex = 0;

        IndexInfo(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }
}

