/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jp.co.nissy.jpicosheet.core.Calculator;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Resolver;
import jp.co.nissy.jpicosheet.core.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    private String _name;
    private Map<String, Cell> _cells;
    private Sheet _sheet;
    static final String GROUP_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*@";
    private static Pattern _groupNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*@");
    static final String FULLY_QUALIFIED_GROUP_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*@";
    private static Pattern _fullyQualifiedGroupNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*@");

    Group(String groupName, Sheet sheet) {
        this.validateGroupName(groupName);
        this._name = groupName;
        this._sheet = sheet;
        this._cells = new HashMap<String, Cell>();
    }

    public String getName() {
        return this._name;
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this._sheet.getName()) + "!" + this._name;
    }

    public Group addCell(Cell cell) {
        if (!this._sheet.equals(cell.getSheet())) {
            throw new IllegalArgumentException("\u30b0\u30eb\u30fc\u30d7" + this.getName() + "\u306b\u7570\u306a\u308b\u30b7\u30fc\u30c8" + cell.getSheet() + "\u306b\u5c5e\u3059\u308b\u30bb\u30eb" + cell.getName() + "\u3092\u8ffd\u52a0\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        this._cells.put(cell.getName(), cell);
        Resolver resolver = this._sheet.getBook().getResolver();
        Set<Cell> groupReferencesCells = resolver.getReferencingCells(this);
        for (Cell referencesCell : groupReferencesCells) {
            resolver.registGroupReferences(referencesCell, this.getName());
        }
        this.recalcReferencingCell(this);
        return this;
    }

    public Group addCells(Collection<Cell> cells) {
        Iterator<Cell> iter = cells.iterator();
        while (iter.hasNext()) {
            this.addCell(iter.next());
        }
        return this;
    }

    public Group addCell(String cellName) throws ReferenceNotFoundException {
        Resolver resolver = this._sheet.getBook().getResolver();
        this.addCell(resolver.getCell(cellName));
        return this;
    }

    public Group addCells(String[] cellNames) throws ReferenceNotFoundException {
        String[] stringArray = cellNames;
        int n = cellNames.length;
        int n2 = 0;
        while (n2 < n) {
            String cellName = stringArray[n2];
            this.addCell(cellName);
            ++n2;
        }
        return this;
    }

    public Group removeCell(Cell cell) {
        this._cells.remove(cell.getName());
        this.recalcReferencingCell(this);
        return this;
    }

    public Group removeCell(String cellName) {
        try {
            Cell removeCell = this._sheet.getCell(cellName);
            this.removeCell(removeCell);
        }
        catch (ReferenceNotFoundException referenceNotFoundException) {
            // empty catch block
        }
        return this;
    }

    public Collection<Cell> getCells() {
        return this._cells.values();
    }

    private void validateGroupName(String groupName) throws IllegalArgumentException {
        if (!_groupNamePattern.matcher(groupName).matches()) {
            throw new IllegalArgumentException("invalid group name \"" + groupName + "\"");
        }
    }

    static boolean isValidGroupName(String groupName) {
        return _groupNamePattern.matcher(groupName).matches();
    }

    static boolean isValidFullyQualifiedGroupName(String fullyQualifiedGroupName) {
        return _fullyQualifiedGroupNamePattern.matcher(fullyQualifiedGroupName).matches();
    }

    private void recalcReferencingCell(Group group) {
        Resolver resolver = group._sheet.getBook().getResolver();
        Calculator calcurator = group._sheet.getBook().getCalculator();
        Set<Cell> referencingCells = resolver.getReferencingCells(group);
        for (Cell cell : referencingCells) {
            cell.setStatus(Cell.CellStatus.RequireCalculation);
            calcurator.calc(cell);
        }
    }
}

