/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.CircularReferenceException;
import jp.co.nissy.jpicosheet.core.Group;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver {
    private Book _book;
    private Sheet _defaultSheet;
    private Map<String, Set<Cell>> _references;

    private Resolver() {
    }

    Resolver(Book book) {
        this._book = book;
        this._references = new HashMap<String, Set<Cell>>();
    }

    void setDefaultSheet(Sheet defaultSheet) {
        this._defaultSheet = defaultSheet;
    }

    Sheet getDefaultSheet() {
        return this._defaultSheet;
    }

    String getFullyQualifiedName(Sheet sheet, String name) {
        if (name.contains("!")) {
            return name;
        }
        return String.valueOf(sheet.getName()) + "!" + name;
    }

    public boolean cellExists(String cellName) throws ReferenceNotFoundException {
        if (cellName.contains("!")) {
            String[] sheetCell = cellName.split("!");
            return this._book.sheet(sheetCell[0]).cellExists(cellName);
        }
        return this._defaultSheet.cellExists(cellName);
    }

    public Cell getCell(String cellName) throws ReferenceNotFoundException {
        if (cellName.contains("!")) {
            String[] sheetCell = cellName.split("!");
            return this._book.sheet(sheetCell[0]).getCell(sheetCell[1]);
        }
        return this._defaultSheet.getCell(cellName);
    }

    public Set<Cell> getCellsByGroup(String groupName) throws ReferenceNotFoundException, CircularReferenceException {
        String targetGroup;
        Sheet targetSheet;
        if (groupName.contains("!")) {
            String[] sheetGroup = groupName.split("!");
            targetSheet = this._book.sheet(sheetGroup[0]);
            targetGroup = sheetGroup[1];
        } else {
            targetSheet = this._defaultSheet;
            targetGroup = groupName;
        }
        return new HashSet<Cell>(targetSheet.getGroup(targetGroup).getCells());
    }

    void registReferences(Cell referenceCell, String referencesCellName) {
        String fqn = this.getFullyQualifiedName(referenceCell.getSheet(), referencesCellName);
        if (!this._references.containsKey(fqn)) {
            this._references.put(fqn, new HashSet());
        }
        this._references.get(fqn).add(referenceCell);
    }

    void removeReferences(Cell referenceCell, String referencesCellName) {
        String fqn = this.getFullyQualifiedName(referenceCell.getSheet(), referencesCellName);
        if (this._references.containsKey(fqn)) {
            this._references.get(fqn).remove(referenceCell);
            if (this._references.get(fqn).size() == 0) {
                this._references.remove(fqn);
            }
        }
    }

    Set<Cell> getReferencingCells(Cell referenceCell) {
        HashSet<Cell> returnCell = new HashSet<Cell>();
        this.getReferencingCellsRecursive(referenceCell, returnCell);
        return returnCell;
    }

    private void getReferencingCellsRecursive(Cell cell, Set<Cell> referencingCells) {
        Set<Cell> set = this._references.get(cell.getFullyQualifiedName());
        if (set == null) {
            return;
        }
        for (Cell refCell : set) {
            if (referencingCells.contains(refCell)) continue;
            referencingCells.add(refCell);
            this.getReferencingCellsRecursive(refCell, referencingCells);
        }
    }

    Set<Cell> getReferencingCells(Group referenceGroup) {
        HashSet<Cell> returnCell = new HashSet<Cell>();
        if (this._references.containsKey(referenceGroup.getFullyQualifiedName())) {
            returnCell.addAll((Collection<Cell>)this._references.get(referenceGroup.getFullyQualifiedName()));
            return returnCell;
        }
        return returnCell;
    }

    public boolean groupExists(String groupName) throws ReferenceNotFoundException {
        if (groupName.contains("!")) {
            String[] sheetCell = groupName.split("!");
            return this._book.sheet(sheetCell[0]).cellExists(groupName);
        }
        return this._defaultSheet.cellExists(groupName);
    }

    public Group getGroup(String groupName) throws ReferenceNotFoundException {
        if (groupName.contains("!")) {
            String[] sheetGroup = groupName.split("!");
            return this._book.sheet(sheetGroup[0]).getGroup(sheetGroup[1]);
        }
        return this._defaultSheet.getGroup(groupName);
    }

    void registGroupReferences(Cell cell, String referenceGroupName) {
        String fqn = this.getFullyQualifiedName(cell.getSheet(), referenceGroupName);
        this.registReferences(cell, fqn);
        Group group = null;
        try {
            group = cell.getSheet().getGroup(fqn);
        }
        catch (ReferenceNotFoundException e) {
            return;
        }
        for (Cell memberCell : group.getCells()) {
            this.registReferences(cell, memberCell.getFullyQualifiedName());
        }
    }
}

