/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.Calculator;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.Group;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sheet {
    private String _name;
    private MathContext _mc = MathContext.DECIMAL64;
    private HashMap<String, Cell> _cells;
    private HashMap<String, Group> _groups;
    private HashMap<String, Cell> _errorCells;
    private Book _book;
    static final String SHEET_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static Pattern _sheetNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");

    private Sheet() {
    }

    public Sheet(String sheetName, Book book) throws IllegalArgumentException {
        this.validateSheetName(sheetName);
        this._name = sheetName;
        this._cells = new HashMap();
        this._groups = new HashMap();
        this._errorCells = new HashMap();
        this._book = book;
    }

    public Sheet(String sheetName, Book book, MathContext mc) throws IllegalArgumentException {
        this(sheetName, book);
        this._mc = mc;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String sheetName) throws IllegalArgumentException {
        this.validateSheetName(sheetName);
        this._name = sheetName;
    }

    public Book getBook() {
        return this._book;
    }

    public MathContext getMathContext() {
        return this._mc;
    }

    public void setMathContext(MathContext mc) {
        this._mc = mc;
    }

    public boolean cellExists(String cellName) throws IllegalArgumentException {
        return this._cells.containsKey(this.getShortName(cellName));
    }

    public boolean cellExists(Cell cell) {
        return this._cells.containsValue(cell);
    }

    public Cell addCell(String cellName) {
        String shortName = this.getShortName(cellName);
        if (this._cells.containsKey(shortName)) {
            return this._cells.get(shortName);
        }
        Cell cell = new Cell(shortName, this);
        this._cells.put(shortName, cell);
        return cell;
    }

    public Cell getCell(String cellName) throws ReferenceNotFoundException {
        String shortName = this.getShortName(cellName);
        if (this._cells.containsKey(shortName)) {
            return this._cells.get(shortName);
        }
        throw new ReferenceNotFoundException("cellname " + cellName + " is not found");
    }

    public List<Cell> getCells() {
        return new ArrayList<Cell>(this._cells.values());
    }

    public boolean containsErrorCell() {
        return !this._errorCells.isEmpty();
    }

    public Map<String, Cell> getErrorCells() {
        return new HashMap<String, Cell>(this._errorCells);
    }

    void addErrorCell(Cell cell) {
        if (this._cells.containsKey(cell.getName())) {
            this._errorCells.put(cell.getName(), cell);
        }
    }

    void removeErrorCell(Cell cell) {
        this._errorCells.remove(cell.getName());
    }

    void removeAllErrorCell() {
        this._errorCells.clear();
    }

    public void renameCell(String cellName, String newCellName) throws ReferenceNotFoundException, IllegalArgumentException {
        String shortCellName = this.getShortName(cellName);
        String shortNewCellName = this.getShortName(newCellName);
        if (this._cells.containsKey(shortCellName)) {
            Cell cell = this._cells.get(shortCellName);
            cell.setName(shortNewCellName);
            this._cells.put(shortNewCellName, this._cells.get(shortCellName));
            this._cells.remove(shortCellName);
            if (this._errorCells.containsKey(shortCellName)) {
                this._errorCells.put(shortNewCellName, this._errorCells.get(shortCellName));
                this._errorCells.remove(shortCellName);
            }
        } else {
            throw new ReferenceNotFoundException("cellname " + cellName + "is not found");
        }
    }

    public void deleteCell(Cell cell) {
        this.deleteCell(cell.getName());
    }

    public void deleteCell(String cellName) throws IllegalArgumentException {
        String shortName = this.getShortName(cellName);
        if (this._cells.containsKey(shortName)) {
            this._cells.remove(shortName);
            this._errorCells.remove(shortName);
        }
    }

    private String getShortName(String cellName) throws IllegalArgumentException {
        if (cellName.contains("!")) {
            int delimiterIndex = cellName.indexOf("!");
            String argSheetName = cellName.substring(0, delimiterIndex);
            if (!argSheetName.equals(this._name)) {
                throw new IllegalArgumentException("Invalid Sheetname " + argSheetName);
            }
            return cellName.substring(delimiterIndex + 1);
        }
        return cellName;
    }

    public boolean groupExists(String groupName) {
        return this._groups.containsKey(this.getShortName(groupName));
    }

    public boolean groupExists(Group group) {
        return this._groups.containsValue(group);
    }

    public Group addGroup(String groupName) {
        String shortGroupName = this.getShortName(groupName);
        if (this._groups.containsKey(shortGroupName)) {
            return this._groups.get(shortGroupName);
        }
        Group group = new Group(shortGroupName, this);
        this._groups.put(shortGroupName, group);
        this.recalcReferencingCell(group);
        return group;
    }

    public Group getGroup(String groupName) throws ReferenceNotFoundException {
        String shortGroupName = this.getShortName(groupName);
        if (this._groups.containsKey(shortGroupName)) {
            return this._groups.get(shortGroupName);
        }
        throw new ReferenceNotFoundException("groupname " + groupName + " is not found");
    }

    public void deleteGroup(Group group) {
        this._groups.remove(group.getName());
        this.recalcReferencingCell(group);
    }

    public void deleteGroup(String groupName) {
        String shortGroupName = this.getShortName(groupName);
        if (this._groups.containsKey(shortGroupName)) {
            this.deleteGroup(this._groups.get(shortGroupName));
        }
    }

    private void validateSheetName(String sheetName) throws IllegalArgumentException {
        if (!_sheetNamePattern.matcher(sheetName).matches()) {
            throw new IllegalArgumentException("invalid sheet _name \"" + sheetName + "\"");
        }
    }

    private void recalcReferencingCell(Group group) {
        Resolver resolver = this.getBook().getResolver();
        Calculator calcurator = this.getBook().getCalculator();
        Set<Cell> referencingCells = resolver.getReferencingCells(group);
        for (Cell cell : referencingCells) {
            cell.setStatus(Cell.CellStatus.RequireCalculation);
            calcurator.calc(cell);
        }
    }
}

