/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.function;

import java.math.BigDecimal;
import java.math.MathContext;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.CircularReferenceException;
import jp.co.nissy.jpicosheet.core.Element;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Resolver;
import jp.co.nissy.jpicosheet.function.Function;

public class Sum
extends Function {
    public Element call(Element[] elements, MathContext mc, Resolver resolver) {
        BigDecimal result = BigDecimal.ZERO;
        Element[] elementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Element elem = elementArray[n2];
            if (elem.getType() == Element.ElementType.GroupReference) {
                try {
                    for (Cell cell : resolver.getCellsByGroup(elem.getGroupReference())) {
                        result = result.add(cell.getValue().getNumber());
                    }
                }
                catch (CircularReferenceException e) {
                    return new Element(Element.ElementType.Error, (Object)Element.ErrorType.CirculerReference);
                }
                catch (ReferenceNotFoundException e) {
                    return new Element(Element.ElementType.Error, (Object)Element.ErrorType.InvalidReferences);
                }
            } else {
                result = result.add(elem.getNumber(), mc);
            }
            ++n2;
        }
        return new Element(Element.ElementType.Number, result);
    }
}

