/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.util.HashMap;
import jp.co.nissy.jpicosheet.core.BuiltinFunctionsConstants;
import jp.co.nissy.jpicosheet.core.Function;

class FunctionFactory {
    private HashMap<String, Function> _functionMap = new HashMap();

    FunctionFactory() {
    }

    void loadBuiltinFunctions() {
        try {
            this.loadFunctions(BuiltinFunctionsConstants.BUILTIN_FUNCTIONS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void loadFunctions(String[][] functionDefinition) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        int i = 0;
        while (i < functionDefinition.length) {
            Object obj;
            String uppercaseFunctionName = functionDefinition[i][0];
            String functionClassName = functionDefinition[i][1];
            try {
                obj = Class.forName(functionClassName).newInstance();
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            if (!(obj instanceof Function)) {
                throw new IllegalArgumentException(String.valueOf(functionClassName) + "\u306fFunction\u30af\u30e9\u30b9\u306e\u30b5\u30d6\u30af\u30e9\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
            this.removeFunction(functionDefinition[i][0]);
            this._functionMap.put(uppercaseFunctionName, (Function)obj);
            ++i;
        }
    }

    void removeFunction(String functionName) {
        String upperFunctionName = functionName.toUpperCase();
        if (this._functionMap.containsKey(upperFunctionName)) {
            this._functionMap.remove(upperFunctionName);
        }
    }

    void removeAllFunctions() {
        this._functionMap.clear();
    }

    boolean hasFunction(String functionName) {
        String upperdFunctionName = functionName.toUpperCase();
        return this._functionMap.containsKey(upperdFunctionName);
    }

    Function getFunctionInstance(String functionName) {
        String upperdFunctionName = functionName.toUpperCase();
        return this._functionMap.get(upperdFunctionName);
    }

    String[] getFunctionNmes() {
        String[] strArrayType = new String[]{""};
        return this._functionMap.keySet().toArray(strArrayType);
    }
}

