/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.math.MathContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.Calculator;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.Group;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Resolver;
import jp.co.nissy.jpicosheet.core.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sheet
implements Comparable<Sheet> {
    private String _name;
    private MathContext _mc = MathContext.DECIMAL64;
    private HashMap<String, Cell> _cells;
    private HashMap<String, Group> _groups;
    private HashMap<String, Table> _tables;
    private HashMap<String, Cell> _errorCells;
    private Book _book;
    static final String SHEET_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static Pattern _sheetNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");

    private Sheet() {
    }

    public Sheet(String sheetName, Book book) throws IllegalArgumentException {
        this.validateSheetName(sheetName);
        this._name = sheetName;
        this._cells = new HashMap();
        this._groups = new HashMap();
        this._tables = new HashMap();
        this._errorCells = new HashMap();
        this._book = book;
    }

    public Sheet(String sheetName, Book book, MathContext mc) throws IllegalArgumentException {
        this(sheetName, book);
        this._mc = mc;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String sheetName) throws IllegalArgumentException {
        this.validateSheetName(sheetName);
        this._name = sheetName;
    }

    public Book getBook() {
        return this._book;
    }

    public MathContext getMathContext() {
        return this._mc;
    }

    public void setMathContext(MathContext mc) {
        this._mc = mc;
        Calculator calculator = this._book.getCalculator();
        if (calculator.isRecalcEnable()) {
            calculator.recalcDisable();
            for (Cell cell : this.getCells()) {
                if (cell.getCellType() != Cell.CellType.FORMULA) continue;
                cell.setStatus(Cell.CellStatus.REQUIRE_CALCULATION);
            }
            calculator.recalcEnable();
        }
    }

    public boolean cellExists(String cellName) throws IllegalArgumentException {
        return this._cells.containsKey(this.getShortName(cellName));
    }

    public boolean cellExists(Cell cell) {
        return this._cells.containsValue(cell);
    }

    public Cell addCell(String cellName) {
        return this.addCell(cellName, false);
    }

    Cell addCell(String cellName, boolean forTableCell) {
        String shortName = this.getShortName(cellName);
        if (this._cells.containsKey(shortName)) {
            return this._cells.get(shortName);
        }
        Cell cell = new Cell(shortName, this, forTableCell);
        this._cells.put(shortName, cell);
        return cell;
    }

    public Cell getCell(String cellName) {
        String shortName = this.getShortName(cellName);
        if (this._cells.containsKey(shortName)) {
            return this._cells.get(shortName);
        }
        throw new ReferenceNotFoundException("cellname " + cellName + " is not found");
    }

    public Set<Cell> getCells() {
        return new HashSet<Cell>(this._cells.values());
    }

    public Set<String> getCellNames() {
        return new HashSet<String>(this._cells.keySet());
    }

    public boolean containsErrorCell() {
        return !this._errorCells.isEmpty();
    }

    public Map<String, Cell> getErrorCells() {
        return new HashMap<String, Cell>(this._errorCells);
    }

    void addErrorCell(Cell cell) {
        if (this._cells.containsKey(cell.getName())) {
            this._errorCells.put(cell.getName(), cell);
        }
    }

    void removeErrorCell(Cell cell) {
        this._errorCells.remove(cell.getName());
    }

    void removeAllErrorCell() {
        this._errorCells.clear();
    }

    public void renameCell(String cellName, String newCellName) {
        String shortCellName = this.getShortName(cellName);
        String shortNewCellName = this.getShortName(newCellName);
        if (!this._cells.containsKey(shortCellName)) {
            throw new ReferenceNotFoundException("cellname " + cellName + "is not found");
        }
        if (cellName.equals(newCellName)) {
            return;
        }
        Cell cell = this._cells.get(shortCellName);
        Set<Cell> oldReferenceCells = this._book.getResolver().getReferencingCells(cell);
        boolean isTableCell = Table.isValidTableNameWithAddress(shortCellName);
        cell.setName(shortNewCellName, isTableCell);
        this._cells.put(shortNewCellName, this._cells.get(shortCellName));
        this._cells.remove(shortCellName);
        if (this._errorCells.containsKey(shortCellName)) {
            this._errorCells.put(shortNewCellName, this._errorCells.get(shortCellName));
            this._errorCells.remove(shortCellName);
        }
        Calculator calculator = this._book.getCalculator();
        calculator.recalcReferencingCells(oldReferenceCells);
        calculator.recalcReferencingCells(cell);
    }

    public void deleteCell(Cell cell) {
        this.deleteCell(cell.getName());
    }

    public void deleteCell(String cellName) throws IllegalArgumentException {
        String shortName = this.getShortName(cellName);
        if (this._cells.containsKey(shortName)) {
            this._cells.remove(shortName);
            this._errorCells.remove(shortName);
        }
    }

    private String getShortName(String cellName) throws IllegalArgumentException {
        if (cellName.contains("!")) {
            int delimiterIndex = cellName.indexOf("!");
            String argSheetName = cellName.substring(0, delimiterIndex);
            if (!argSheetName.equals(this._name)) {
                throw new IllegalArgumentException("Invalid Sheetname " + argSheetName);
            }
            return cellName.substring(delimiterIndex + 1);
        }
        return cellName;
    }

    public boolean groupExists(String groupName) {
        return this._groups.containsKey(this.getShortName(groupName));
    }

    public boolean groupExists(Group group) {
        return this._groups.containsValue(group);
    }

    public Group addGroup(String groupName) {
        String shortGroupName = this.getShortName(groupName);
        if (this._groups.containsKey(shortGroupName)) {
            return this._groups.get(shortGroupName);
        }
        Group group = new Group(shortGroupName, this);
        this._groups.put(shortGroupName, group);
        this.recalcReferencingCell(group);
        return group;
    }

    public Group getGroup(String groupName) throws ReferenceNotFoundException {
        String shortGroupName = this.getShortName(groupName);
        if (this._groups.containsKey(shortGroupName)) {
            return this._groups.get(shortGroupName);
        }
        throw new ReferenceNotFoundException("groupname " + groupName + " is not found");
    }

    public Set<Group> getGroups() {
        return new HashSet<Group>(this._groups.values());
    }

    public void deleteGroup(Group group) {
        this._groups.remove(group.getName());
        this.recalcReferencingCell(group);
    }

    public void deleteGroup(String groupName) {
        String shortGroupName = this.getShortName(groupName);
        if (this._groups.containsKey(shortGroupName)) {
            this.deleteGroup(this._groups.get(shortGroupName));
        }
    }

    public boolean tableExists(String tableName) {
        return this._tables.containsKey(this.getShortName(tableName));
    }

    public boolean tableExists(Table table) {
        return this._tables.containsValue(table);
    }

    public Table addTable(String tableName, int rowSize, int colSize) {
        String shortTableName = this.getShortName(tableName);
        if (this._tables.containsKey(shortTableName)) {
            return this._tables.get(shortTableName);
        }
        Table table = new Table(shortTableName, rowSize, colSize, this);
        this._tables.put(shortTableName, table);
        return table;
    }

    public Table getTable(String tableName) throws ReferenceNotFoundException {
        String shortTableName = this.getShortName(tableName);
        if (this._tables.containsKey(shortTableName)) {
            return this._tables.get(shortTableName);
        }
        throw new ReferenceNotFoundException("tablename " + tableName + " is not found");
    }

    public Set<Table> getTables() {
        return new HashSet<Table>(this._tables.values());
    }

    public void deleteTable(Table table) {
        this._tables.remove(table.getName());
    }

    public void deleteTable(String tableName) {
        String shortTableName = this.getShortName(tableName);
        if (this._groups.containsKey(shortTableName)) {
            this.deleteGroup(this._groups.get(shortTableName));
        }
    }

    private void validateSheetName(String sheetName) throws IllegalArgumentException {
        if (!_sheetNamePattern.matcher(sheetName).matches()) {
            throw new IllegalArgumentException("invalid sheet _name \"" + sheetName + "\"");
        }
    }

    private void recalcReferencingCell(Group group) {
        Resolver resolver = this.getBook().getResolver();
        Calculator calcurator = this.getBook().getCalculator();
        Set<Cell> referencingCells = resolver.getReferencingCells(group);
        for (Cell cell : referencingCells) {
            cell.setStatus(Cell.CellStatus.REQUIRE_CALCULATION);
            calcurator.calc(cell);
        }
    }

    @Override
    public int compareTo(Sheet o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        return obj instanceof Sheet && this.hashCode() == ((Sheet)obj).hashCode();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return super.toString();
    }
}

