/**
 * JPicosheet: Spreadsheet engine for Java Applications
 * Copyright (C) 2011 yusuke nishikawa
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
/**
 *
 */
package com.nissy_ki_chi.jpicosheet.function;

import java.math.BigDecimal;
import java.math.MathContext;

import com.nissy_ki_chi.jpicosheet.core.Element;
import com.nissy_ki_chi.jpicosheet.core.Function;
import com.nissy_ki_chi.jpicosheet.core.Resolver;
import com.nissy_ki_chi.jpicosheet.core.Element.ElementType;


/**
 * @author yusuke nishikawa
 *
 */
public class AVERAGE extends Function {

	/* (非 Javadoc)
	 * @see com.nissy_ki_chi.jpicosheet.function.Function#call(com.nissy_ki_chi.jpicosheet.core.Element[], java.math.MathContext, com.nissy_ki_chi.jpicosheet.core.Resolver)
	 */
	@Override
	public Element call(Element[] elements, MathContext mc, Resolver resolver) {
		// elementsの値の平均を返す
		BigDecimal result = BigDecimal.ZERO;

		if (elements.length > 0) {
			for(Element e: elements) {
				result = result.add(e.getNumber(), mc);
			}
			result = result.divide(new BigDecimal(elements.length), mc);
		}
		return Element.newElement(ElementType.NUMBER, result);
	}


}
