/**
 * JPicosheet: Spreadsheet engine for Java Applications
 * Copyright (C) 2011 yusuke nishikawa
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package test;

import com.nissy_ki_chi.jpicosheet.core.Book;
import com.nissy_ki_chi.jpicosheet.core.Range;
import com.nissy_ki_chi.jpicosheet.core.Sheet;
import com.nissy_ki_chi.jpicosheet.core.Table;

import junit.framework.TestCase;



public class RangeTest extends TestCase {

Book book;
Sheet sheet;
Table table;


	protected void setUp() throws Exception {
		super.setUp();
		book= new Book("myBook");
		sheet = book.addSheet("mySheet");
		table = sheet.addTable("myTable#", 10, 10);

		for (int i = 0; i < table.getRowSize(); i++) {
			for (int o = 0; o < table.getColSize(); o++) {
				sheet.getTable("myTable#").getCell(i, o)
					.setStringValue("R" + Integer.toString(i) + "C" + Integer.toString(o));
			}
		}
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}



	public void testGetCell() {
		Range range = table.getRange("R0C0:R4C4");

		assertEquals("R0C0", range.getCell(0,0).getValueString());
		assertEquals("R1C1", range.getCell(1,1).getValueString());
		assertEquals("R4C4", range.getCell(4,4).getValueString());
	}



}
